package com.cusc.adas.v2x.clouddecision.dto;

import java.util.List;

import com.cusc.adas.v2x.utils.FieldDef;
import com.cusc.adas.v2x.utils.Order;

/**
 * 云端决策建议信息报文体
 * @author huangml
 *
 */
public class CloudDecisionMessageBodyDto<T> {
	//车辆编号
	@Order(1)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private String vehicleId;
	
	//消息标识
	@Order(2)
	@FieldDef(type="BYTE",isArray=true,length=8)
	private long seq;
	
	//建议类型 若为多功能决策时，取值为 254
	@Order(3)
	private short adviceType;
	
	//事件分类
	@Order(4)
	private short eventType;
	
	//车速建议 单位：0.01m/s
	@Order(5)
	private int spdExp;
	
	//加速度建议 单位：0.01  m/s2，数据偏移量 100，表示-100.00m/s2～100.00m/s2
	@Order(6)
	private int accExp;
	
	//控车变道建 议转向状态 0：沿车道行驶；1：第一出口；2：第二出口；
	//3：第三出口；4：第四出口；5：第五出口；6：第六出口；7：第七 出口；8：第八出口；9：左变道；10：右变道
	@Order(7)
	private short instructDirection;
	
	//命令长度 0 表示命令失效，此时该条消息全部无效
	@Order(8)
	private int dataLen;
	//命令数据 长度为 N 个字节，其中 N 为命令长度
	@Order(9)
	private List<T> adviceData;
}
