package com.sd.cavphmi.websockets

import com.sd.cavphmi.intfaces.OnWebSocketCb
import org.java_websocket.handshake.ServerHandshake
import java.net.URI
import java.nio.ByteBuffer

/*****v2x预警**/
class V2xWSClient : BaseWsClient {

    private val TAG = "-----V2xWSClient"

    constructor(serverUri: URI) : super(serverUri)
//
//    constructor(serverUri: URI?, protocolDraft: Draft?) : super(serverUri, protocolDraft)
//
//    constructor(serverUri: URI?, httpHeaders: MutableMap<String, String>?) : super(
//        serverUri,
//        httpHeaders
//    )

    var onWebSocketCb: OnWebSocketCb? = null

    override fun onOpen(handshakedata: ServerHandshake?) {
//        send("Hello, it is me. Mario :)")
        println(TAG + "------v2x预警 "+uri.toString())
    }

    override fun onMessage(message: String?) {
        println(TAG + " : " + message)
        if (message.isNullOrEmpty())
            return
        onWebSocketCb?.onMsg(message)
    }

    override fun onMessage(bytes: ByteBuffer?) {
//        System.out.println(TAG + "  received ByteBuffer")
    }

    override fun onClose(code: Int, reason: String?, remote: Boolean) {
        System.out.println(TAG + "  closed with exit code " + code + " additional info: " + reason);
    }

    override fun onError(ex: Exception?) {
//        System.err.println(TAG + "an error occurred:" + ex)
    }


}