package com.sd.cavphmi.ui.fragment

import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.viewmodels.MainVm
import com.sd.cavphmi.viewmodels.UnityMapVm
import com.unity3d.player.IUnityPlayerLifecycleEvents
import com.unity3d.player.UnityPlayer

class UnityFragment : Fragment() {
    override fun onResume() {
        super.onResume()
        mUnityPlayer.onResume()
    }

    override fun onStart() {
        super.onStart()
        mUnityPlayer.onStart()
    }

    override fun onPause() {
        super.onPause()
        mUnityPlayer.onPause()
    }

    override fun onStop() {
        super.onStop()
        mUnityPlayer.onStop()
    }

    override fun onDestroy() {
        super.onDestroy()
//        try {
        mUnityPlayer.destroy()
//        } catch (e: Exception) {
////            e.printStackTrace()
//        }
    }

    override fun onDestroyView() {
        super.onDestroyView()
        frameLayout.removeView(mUnityPlayer.rootView)
    }

    private lateinit var frameLayout: FrameLayout

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // 创建一个简单的 FrameLayout 作为 Fragment 的根视图
        frameLayout = FrameLayout(requireContext())
        frameLayout.layoutParams = ViewGroup.LayoutParams(-1, -1)
//        // 将 UnityPlayer 的视图添加到 FrameLayout 中
        mUnityPlayer.let { unityPlayer ->
//            val playerView = unityPlayer
            val layoutParams = ViewGroup.LayoutParams(-1, -1)
            frameLayout.addView(unityPlayer, layoutParams)
        }
        return frameLayout
    }

    // UnityPlayer 实例
    private lateinit var mUnityPlayer: UnityPlayer

    //UNITY map 控制类
    private val unityMapVm: UnityMapVm by activityViewModels()

    //主页
    private val mainVm: MainVm by activityViewModels()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mUnityPlayer = UnityPlayer(requireContext())
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        // 视图创建完成后，可以在这里进行最终设置
        mUnityPlayer.requestFocus()
        mUnityPlayer.setFocusableInTouchMode(true)
        //使用拼接服务器资源加载地图
        unityMapVm.loadTileJson()
//        mUnityPlayer.postDelayed({
//            try {
        HighMapApi.setCarBottomCircle(true)
        HighMapApi.setCameraAngle(30f)
        HighMapApi.setCameraDistance(8f)
//            } catch (e: Exception) {
//            }
//        }, 300)
        setListener()
    }

    private fun setListener() {
        mainVm.hasFocus.observe(viewLifecycleOwner) { hasFocus ->
            mUnityPlayer.windowFocusChanged(hasFocus)
        }
        mainVm.windowConfiguration.observe(viewLifecycleOwner) { configuration->
            mUnityPlayer.configurationChanged(configuration)
        }
    }

    companion object {
        @JvmStatic
        fun newInstance() = UnityFragment()
    }

}