package com.sd.cavphmi.viewmodels

import androidx.lifecycle.viewModelScope
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.CarPanelBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.VehicleDynamic
import com.sd.cavphmi.utils.AvpContants
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext
import java.lang.NullPointerException
import javax.inject.Inject
import kotlin.random.Random

@HiltViewModel
class CarPanelVM @Inject constructor() : MyBaseViewModel() {

    //车辆仪表单例
    var carPanelBean = CarPanelBean.instance

    /**展示车辆仪表*****/
    fun setCarPanelBean(dynamic: VehicleDynamic) {
        //速度
        carPanelBean.speed.set(dynamic.speed.toInt())
        //驾驶模式
        carPanelBean.driveMode.set(dynamic.drivingMode)
        //航向角
        carPanelBean.heading.set(dynamic.speed.toInt())
        //电量
        carPanelBean.remainSoc.set(100)

        //档位
        var gearType = dynamic.gearType
        when (gearType) {
            AvpContants.GEAR_NEUTRAL -> {
                carPanelBean.tapPos.set(0)
            }

            AvpContants.GEAR_PARK -> {
                carPanelBean.tapPos.set(1)
            }

            AvpContants.GEAR_DRIVE -> {
                carPanelBean.tapPos.set(2)
            }

            AvpContants.GEAR_REVERSE -> {
                carPanelBean.tapPos.set(3)
            }

            AvpContants.GEAR_UNKNOWN -> {
                carPanelBean.tapPos.set(7)
            }
        }
    }


    fun mock() {
        //速度
        carPanelBean.speed.set(30)
        //驾驶模式
        carPanelBean.driveMode.set(AvpContants.DRIVE_MODE_AUTOMATIC)
        //航向角
        carPanelBean.heading.set(0)
        //电量
        carPanelBean.remainSoc.set(100)
        //档位
        carPanelBean.tapPos.set(2)
//        changeMockHeading()
//        changeMockDriveMode()
//        changeMockLight()
//        changeMockPro()
//        changeMockGear()
//        changeMockSpeed()
    }


    private fun changeMockHeading() {
        viewModelScope.launch {
            var list = mutableListOf<Int>()
            var ramdom = Random(360)
            for (i in 1..360) {
                list.add(ramdom.nextInt(360))
            }
            list.forEach {
                withContext(Dispatchers.IO) {
                    carPanelBean.heading.set(it)
                    delay(600)
                }
            }
        }
    }

    //模拟驾驶模式
    private fun changeMockDriveMode() {
        var list = listOf(
            AvpContants.DRIVE_MODE_REMOTE,
            AvpContants.DRIVE_MODE_UNKNOWN,
            AvpContants.DRIVE_MODE_MANUAL,
            AvpContants.DRIVE_MODE_AUTOMATIC
        )
        viewModelScope.launch {
            for (i in 1..100) {
                for (j in 0..3) {
                    withContext(Dispatchers.Default) {
                        delay(500)
                    }
                    carPanelBean.driveMode.set(list[j])
                }
            }
        }
    }

    //模拟车灯
    private fun changeMockLight() {
        var list = listOf(4, 8, 0)
        viewModelScope.launch {
            for (i in 1..100) {
                withContext(Dispatchers.IO) {
                    delay(2000)
                }
                var p = i % 3
//                carPanelBean.lights.set(list[p])
            }
        }
    }

    //模拟电量
    private fun changeMockPro() {
        viewModelScope.launch {
            for (i in 1..1000) {
                withContext(Dispatchers.IO) {
                    delay(300)
                }
                var p = i % 100
                carPanelBean.remainSoc.set(p)
            }
        }
    }

    //模拟档位
    private fun changeMockGear() {
        var list = listOf(0,1,2,3,7)
            viewModelScope.launch {
                for (i in 1..100) {
                    withContext(Dispatchers.IO) {
                        delay(1000)
                    }
                    var p = i % 5
                    carPanelBean.tapPos.set(list.get(p))
                }
            }
    }

    //模拟速度和限速
    private fun changeMockSpeed() {
//        carPanelBean.spdExp.set(10)
        viewModelScope.launch {
            for (i in 1..100) {
                for (j in 1..100) {
                    withContext(Dispatchers.IO) {
                        delay(200)
                    }
                    carPanelBean.speed.set(j)
                }
            }
        }
    }
}