package com.sd.cavphmi.ui

import android.content.res.Configuration
import android.util.Log
import android.view.KeyEvent
import androidx.activity.viewModels
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.repeatOnLifecycle
import com.minedata.minenavi.SDKInitializer
import com.minedata.minenavi.SDKInitializer.InitListener
import com.minedata.minenavi.map.MapView
import com.minedata.minenavi.map.MineMap
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.util.Tools
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseActivity
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.databinding.ActivityMainBinding
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.LockStatu
import com.sd.cavphmi.highmap.ParkStatu
import com.sd.cavphmi.highmap.Spinfo
import com.sd.cavphmi.highmap.UnityPtc
import com.sd.cavphmi.intfaces.OnConCan
import com.sd.cavphmi.ui.fragment.CarPanelFragment
import com.sd.cavphmi.ui.fragment.ExoPlayFragment
import com.sd.cavphmi.utils.AvpContants
import com.sd.cavphmi.utils.DisplayUtil
import com.sd.cavphmi.utils.ToastHelper
import com.sd.cavphmi.viewmodels.MainVm
import com.sd.cavphmi.viewmodels.MapOpt
import com.sd.cavphmi.viewmodels.MockVM
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch


@AndroidEntryPoint
class MainActivity : BaseActivity<ActivityMainBinding, MyBaseViewModel>() {

    override fun getStatuBarColor(): Int {
        return -1
    }

    override fun initContentView(): Int {
        return R.layout.activity_main
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    override fun onPause() {
        super.onPause()
        binding.mapView.onPause()
    }

    override fun onResume() {
        super.onResume()
        binding.mapView.onResume()
    }

    override fun onDestroy() {
        super.onDestroy()
        mainVm.cleanRes()
        binding.mapView.onDestroy()
    }

    //用作模拟
    private val mockVM: MockVM by viewModels()

    //主页操作
    private val mainVm: MainVm by viewModels()

    //地图操作类，用于绘制
    private val mapOpt: MapOpt by viewModels()

    //    private val avpMapVM: AvpMapVM by viewModels()
    //是否进入泊车倒车状态
//    private var isReversePark = false

    //退出应用弹窗
    private lateinit var dialogFragment: ExitAppDialog

    //汽车仪表
    private val carPanelFragment by lazy { CarPanelFragment.newInstance() }

    //exo播放器
    private val exoPlayFragment by lazy { ExoPlayFragment.newInstance() }
    override fun initView() {
        mainVm.mockVM = mockVM
        adaptWidth()
        //车辆仪表
        var ft = supportFragmentManager.beginTransaction()
        ft.add(R.id.map_car_pan, carPanelFragment, "1")
        ft.commit()

        //添加视频播放器，以后看需要控制显示隐藏时机,默认隐藏
//        showVideoFragment(true)
        initialMap()
    }

    private fun adaptWidth() {
        var width = DisplayUtil.getScreenWidthPx()
        var cWidth = (width * 0.271).toInt()
        //车辆仪表
        var params = binding.mapCarPan.layoutParams
        params.width = cWidth
        binding.mapCarPan.layoutParams = params
        //小地图
        params = binding.smallFLayout.layoutParams.apply {
            this.width = (width * 0.17).toInt()
            this.height = (this.width * 0.75).toInt()
        }
        binding.smallFLayout.layoutParams = params
        //车内视频frag
        params = binding.videoFrag.layoutParams.apply {
            this.width = (width * 0.314).toInt()
            this.height = (this.width * 0.54).toInt()
        }
        binding.videoFrag.layoutParams = params
    }

    private fun initialMap() {
        SDKInitializer.debug(false)
        // 隐私合规接口
        SDKInitializer.setAgreePrivacy(true)
//        SDKInitializer.setStyleUrl(MineMap.UrlType.satellite, MyContants.YZ_WMS)
        SDKInitializer.initialize(this, object : InitListener {
            override fun onInitSuccess() {
//                println("---Map onInitSuccess")
                setUpMap()
            }

            override fun onInitFailed(msg: String?) {
                println("---Map onInitFailed msg = ${msg}")
            }
        })
    }

    private fun setUpMap() {
        binding.mapView.addMapRenderCallback(object : MapView.OnMapReadyListener {
            override fun onMapReady(mineMap: MineMap?) {
//                mainVm.mMineMap = mineMap
                mapOpt.mMineMap = mineMap
                mockVM.mMineMap = mineMap
                mineMap?.setZoomLevel(14f)
                //设置中心点
//                val point = Tools.latLngToPoint(LatLng(39.80913878, 116.50166926))
                val point = Tools.latLngToPoint(LatLng(39.809135, 116.502434))
                mineMap?.setPointToCenter(point.x, point.y)
            }
        })
    }

    override fun getToData() {
        if (!mainVm.isMock) {
            //开启AVP状态(HTTP SSE)
            getAvpStatus()
        }
        //开启V2X预警
        getV2x()
        //开启感知物websocket
        getTarget()
        //开启车辆位姿
        getCarVehicle()
        //获取车位占用情况
//        getSpaceInfo()
    }

    //获取车位占用情况
    private fun getSpaceInfo() {
        mainVm.getSpaceInfo().observe(this) { spaceInfo ->
            //车辆占用情况
            var spinfos = spaceInfo.result.map {
                Spinfo().apply {
                    code = it.code
                    state = true
                }
            }
            HighMapApi.setParkStatu(ParkStatu(spinfos))
        }
    }

    //显示隐藏 视频
    private fun showVideoFragment(show: Boolean) {
        var ft = supportFragmentManager.beginTransaction()
        if (!exoPlayFragment.isAdded) {
            ft.add(R.id.video_frag, exoPlayFragment, "player")
        }
        if (show) {
            ft.show(exoPlayFragment)
        } else {
            ft.hide(exoPlayFragment)
        }
        ft.commit()
    }

    override fun initListener() {
        mockBt()
    }

    //获取AVP状态
    private fun getAvpStatus() {
        lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.STARTED) {
                mainVm.getAvpStatus().collect { avpStatu ->
                    showAvp(avpStatu)
                    // 车内视频
//            isCarVideo(businessStatus)
                }
            }
        }
    }

    //显示AVP特效
    private fun showAvp(avpStatu: AvpStatuBean) {
        if (avpStatu.haulingStageState == null || avpStatu.vehicleContext == null)
            return
        //业务类型
        var businessType = avpStatu.businessType//NIL Park Call
        //业务状态
        var businessStatus = avpStatu.haulingStageState
        //获取档位
        var gearType = avpStatu.vehicleContext.vehicleDynamic.gearType
        //画全局路径
        mapOpt.drawAllLines(avpStatu.drivenDecision, businessStatus)
        //生成小地图路线
        mapOpt.takeSmallMapLine(avpStatu.drivenDecision, businessStatus)
        //画终点
        mapOpt.addEndMarker(avpStatu.drivenDecision.endPoint, businessStatus)
        //是否显示车位流光效果
        mapOpt.showParkLight(businessType, businessStatus, avpStatu.space)
        //判断在泊车状态下的倒挡绘制倒车路线,改变镜头视角,,判断车是否到达停车点
        mapOpt.drawReversePark(businessType, businessStatus, gearType, avpStatu.space)
        //显示提示
        tip(businessType, businessStatus)
        //重置变量
        resetVariable(businessStatus)
        //根据AVP任务状态判停车特效是否关闭
//        mapOpt.showEffectAvpStatu(businessType, businessStatus)
    }

    /***重置变量**/
    private fun resetVariable(businessStatus: String) {
        if (businessStatus == AvpContants.TRANSPORT_COMPLETED || businessStatus == AvpContants.TRANSPORT_CANCELED) {
            mainVm.isGetVehDetail = false
//            mapOpt.smallMapLine = false
            mapOpt.sliceIndex = 0
//            mapOpt.isDrawAreaCount = false
        }
    }

    /***提示业务完成状态**/
    private fun tip(businessType: String, businessStatus: String) {
        if (businessType == AvpContants.PARK_TYPE) {
            when (businessStatus) {
                AvpContants.PARK_COMPLETED -> {
                    ToastHelper.showShort(this, "泊车完成")
                }
            }
        } else if (businessType == AvpContants.CALL_TYPE) {
            when (businessStatus) {
                AvpContants.TRANSPORT_COMPLETED -> {
                    ToastHelper.showShort(this, "召车完成")
                }
            }
        }
    }


    /***是否展示车内视频****/
    private fun isCarVideo(businessStatus: String) {
        if (businessStatus == AvpContants.TRANSPORT_PROGRESS) {
            getVehDetail()
        } else {
//            exoPlayFragment.videoUrl = cameraUrl
            showVideoFragment(false)
        }
    }


    //联网车辆位姿数据
    private fun getCarVehicle() {
        lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.STARTED) {
                mainVm.subVehicle().collect { car ->
                    //更新车辆位置
                    showVehicle(car)
                }
            }
        }
        //召车的时候临时开一下
    /*    mainVm.targetPre.observe(this) {
            showPre(it)
        }*/
    }

    /**更新车辆位置*/
    private fun showVehicle(car: CarVehicle) {
        if (car.vehiclePos == null || car.vehiclePos?.getOrNull(2) == null) {
            //隐藏小车
            return
        }
        //画小地图小车
        mapOpt.drawSmallCar(car)
        //刷新右下角小车位置
        mapOpt.showNavingCarPosition(car)
        //车四周生成矩形
        mapOpt.genFronArea(car)
        //刷新右下角小地图路径
        mapOpt.upSmallMapLine()
        //AVP鹰眼基于剩余路线最小矩形框为中心展示。
        mapOpt.drawEndArea(car)
//            println("----car.heading ${car.heading}")
        //刷新主车位置
        HighMapApi.setCarPosition(
            car.vehiclePos!!.get(2),
            car.vehiclePos!!.get(1),
            car.vehiclePos!!.get(0),
            20.80189
//                car.elevation
        )
//            setCarCamera(1)
    }

    //联网车辆感知物
    private fun getTarget() {
        mainVm.subTarget().observe(this) { it ->
            showPre(it)
        }
    }

    /**绘制感知物****/
    private fun showPre(it: PerceptionBean) {
        if (it.getOrNull(0) == null) {
            return
        }
        var parts = it.flatMap { it.participants }
        if (parts.count() == 0) {
            HighMapApi.clearPtcData()
            return
        }
        var ptcList = parts.map {
            var unityPtc = UnityPtc().apply {
                lat = it.latitude
                lon = it.longitude
                ptcid = it.ptcId
                heading = it.heading
                pType = 1
                if (it.ptcType == "car") {
                    pType = 1
                } else if (it.ptcType == "pedestrian") {
                    pType = 2
                }
            }
            return@map unityPtc
        }
        HighMapApi.setPtcData(ptcList)
    }

    //开启v2x预警
    private fun getV2x() {
        mainVm.subStartV2x().observe(this) { v2x ->
            if (v2x == null)
                return@observe
            if (v2x.objects?.isEmpty() == true || v2x.objects?.getOrNull(1) == null)
                return@observe
            //获取预警感知目标物的id 第一个是自己 第二个是别人
            var v2xId = v2x.objects?.get(1)?.id
//            println("------------v2xId = ${v2xId}")
            if (v2xId == null) {
                return@observe
            }
            Log.e("V2x", "-------------v2xId= ${v2xId}")
//            v2xId = "f117fdfa-feff-0100-85dc-35850000acb0"
            mainVm.startWarning(v2xId)
        }
    }

    //设置跟车视角
    private fun setCarCamera(c: Int) {
        if (c == 1) {
            HighMapApi.setCameraAngle(30f)
            HighMapApi.setCameraDistance(6f)
        } else if (c == 2) {
            HighMapApi.setCameraAngle(90f)
            HighMapApi.setCameraDistance(80f)
        }
    }


    //获取车辆详情，取车内摄像头地址打开左下角的车内视频
    private fun getVehDetail() {
//        if (car?.businessStatus.equals("EXITED")) {
//            exoPlayFragment.videoUrl = ""
//            showVideoFragment(false)
//            return
//        }
        mainVm.getVehDetail().observe(this) { vehDetail ->
            if (vehDetail.result.vehicleInfos.count() == 0)
                return@observe
            var cameraUrl = vehDetail.result.vehicleInfos.get(0).vehicleVideoUrl
            println("---cameraUrl = ${cameraUrl}")
            if (exoPlayFragment.videoUrl.isNotEmpty())
                return@observe
            if (!cameraUrl.isNullOrEmpty()) {
                exoPlayFragment.videoUrl = cameraUrl
                showVideoFragment(true)
            }
        }
    }

    private fun mockBt() {
        //获取AVP状态
        binding.btAvpStatu.setOnClickListener {
            getAvpStatus()
        }
        //联网车辆位姿数据
        binding.btVehicle.setOnClickListener {
            getCarVehicle()
        }
        //感知目标物
        binding.btTarget.setOnClickListener {
            getTarget()
        }
        //  HTTP获取车辆详情
        binding.btVehinfo.setOnClickListener {
            getVehDetail()
        }
        //v2x 预警
        binding.btV2x.setOnClickListener {
            getV2x()
        }
        //车位四周流光
        binding.btParkround.setOnClickListener {
            HighMapApi.setCameraAngle(75f)

            lifecycleScope.launch {
                HighMapApi.parkRoundLight("B021")
                delay(5000)
                HighMapApi.parkRoundLight("")
            }
        }
        //停车位绘制
        binding.btParkstatu.setOnClickListener {
            var spinfos = listOf(Spinfo().apply {
                code = "B020"
                state = true
            }, Spinfo().apply {
                code = "B022"
                state = true
            })
            HighMapApi.setParkStatu(ParkStatu(spinfos))
        }
        //地锁绘制
        binding.btLock.setOnClickListener {
            //释放http资源
//            SimpleSSEClient.instance.cancelContect()

            var lockStatu = LockStatu().apply {
                code = "B021"
                isHide = false
            }
            HighMapApi.setLockStatus(lockStatu)
            /*     lifecycleScope.launch {
                     delay(3000)
                     lockStatu.up = false
                     HighMapApi.setLockStatus(lockStatu)
                     delay(3000)
                     lockStatu.isHide = true
                     HighMapApi.setLockStatus(lockStatu)
                 }*/
        }
        //模拟移动
//        binding.btMove.setOnClickListener {
//            mainVm.mockFzLine()
//        }
        //预警车
        binding.warnCar.setOnClickListener {
            mainVm.mWarnCar()
        }
        //预警人
        binding.warnPeo.setOnClickListener {
            mainVm.mWarnPeo()
        }
    }

    /**
     * Show video play
     * @param isHide false:隐藏 true:显示
     */
    private fun showVideoPlay(isHide: Boolean) {
//        exoPlayFragment.videoUri=""
        var ft = supportFragmentManager.beginTransaction()
        if (isHide) {
            ft.hide(exoPlayFragment)
        } else {
            ft.show(exoPlayFragment)
        }
        ft.commit()
    }


    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        mainVm.windowConfiguration.value = newConfig
    }

    override fun onWindowFocusChanged(hasFocus: Boolean) {
        super.onWindowFocusChanged(hasFocus)
        mainVm.hasFocus.value = hasFocus
    }

    override fun dispatchKeyEvent(event: KeyEvent): Boolean {
        if ((event.getKeyCode() == KeyEvent.KEYCODE_BACK) || event.getKeyCode() == KeyEvent.KEYCODE_HOME) {
//            var ft = supportFragmentManager.beginTransaction()
            dialogFragment = ExitAppDialog()
            dialogFragment.onConCan = object : OnConCan {
                override fun onCon() {
                    finish()
                }

                override fun onCan() {
                }
            }
            dialogFragment.show(supportFragmentManager, "exit")
            return true
        } else {
            return super.dispatchKeyEvent(event)
        }
    }

}

/*  https://docs.qq.com/sheet/DVWdOYXZXdVVrQWts?tab=xxmysv              socket文档
  https://s.apifox.cn/e355c9e1-cdd1-49ab-acb2-54cfc66b1598/320994000e0  大屏文档
获取AVP状态信息 /v1/avp/overview/listAvpStatus   这个曲华烨要做成socket 的推送形式，通过这个接口获取全局路径和局部路径，车辆业务状态。
        通过里面的vehicleId，调车辆详情（/v1/avp/overview/getVehicleInfo）获取车内视频流，
 websocket 那几个连接，都需要传vehicleId，你也可以不传，不传就是获取所有的*/


//reType 不传就是飞渡，可以问张海胜，数据没有的问题可直接在51word群里反馈

//目前没有全局路径规划变化提醒，具体车位占用情况（用来在车位上绘制白模）

//需求文档里的气泡提醒，数据未必有，已实际数据为准

//【腾讯文档】AVP-HMI接口需求清单
//https://docs.qq.com/sheet/DVmNmZ3VhVEFxRkpV?tab=BB08J2
//高精地图沟通文档
//https://docs.qq.com/sheet/DQWhPRkdteGFNWVZi?tab=BB08J2










