package com.sd.cavphmi.net

/**
 * Status of a resource that is provided to the UI.
 *
 *
 * These are usually created by the Repository classes where they return
 * `LiveData<Resource<T>>` to pass back the latest data to the UI with its fetch status.
 */
enum class NetLoadStatus {
    SUCCESS,
    ERROR,
    TOAST,
    LOADING,
    COMPLETE,
    EMPTY,
    NOMOREDATA,
    LOGINTIMEOUT;//登录超时

    private var errorMsg = ""
    private var toastMsg = ""

    fun setErrorMsg(error: String) {
        errorMsg = error
    }


    fun getErrorMsg(): String {
        return errorMsg
    }

    fun getToastMsg(): String {
        return toastMsg
    }

    fun setToastMsg(toastMsg: String) {
        this.toastMsg = toastMsg
    }


}
