package com.sd.cavphmi

import androidx.test.platform.app.InstrumentationRegistry
import androidx.test.ext.junit.runners.AndroidJUnit4
import com.google.gson.Gson
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.util.Tools
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.SM4CryptoHelper
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.test.TestScope
import kotlinx.coroutines.test.UnconfinedTestDispatcher
import org.junit.Assert.assertEquals
import org.junit.Test
import org.junit.runner.RunWith

/**
 * Instrumented test, which will execute on an Android device.
 *
 * See [testing documentation](http://d.android.com/tools/testing).
 */
@RunWith(AndroidJUnit4::class)
class ExampleInstrumentedTest {
    @Test
    fun useAppContext() {
        // Context of the app under test.
        val appContext = InstrumentationRegistry.getInstrumentation().targetContext
        assertEquals("com.sd.cavphmi", appContext.packageName)
    }

    @Test
    fun loginCpy() {
        var pwd = "vUO2dStZDhbd*88FfT84"
        var key = "Cusc@itmp-sm4key".toByteArray()
        var pp = SM4CryptoHelper.encryptECB(key, pwd.toByteArray())
        println("------------------pp = ${pp}")
    }

    @Test
    fun calculateTouYing2() {
//        02runTest
        TestScope(UnconfinedTestDispatcher()).launch {
            var gson = Gson()
            val appContext = InstrumentationRegistry.getInstrumentation().targetContext
            //获取全局路径
            var avpDatas = mutableListOf<String>()
            FileIoUtils.getAssetMock(appContext.applicationContext, "mock/shiche/avp_status_call.txt", avpDatas)
            var str = avpDatas.first()
            val statu = gson.fromJson<AvpStatuBean>(str, AvpStatuBean::class.java)
            //转换小弟提路径点
            var sLatLngs = statu.drivenDecision.trajectory.points.map {
                Tools.latLngToPoint(LatLng(it.latitude, it.longitude))
            }.toTypedArray()
            println("-------------sLatLngs = ${sLatLngs}")
            //点传线段
            val testPoint = mutableListOf<List<Double>>()

            //车辆位姿
            var carDatas = mutableListOf<String>()
            FileIoUtils.getAssetMock(appContext, "mock/shiche/CarVehicle_Call.txt", carDatas)

            carDatas.forEach { str ->
                val cCar = gson.fromJson<CarVehicle>(str, CarVehicle::class.java)
                if (cCar.vehiclePos != null) {

                    delay(300)
                }
            }
//        val testPoint = doubleArrayOf(116.38810256578773, 39.92848759523565) // 北海公园
//            val testPoint = mutableListOf<DoubleArray>()

        }


    }

}