package com.sd.cavphmi.viewmodels

import android.content.Context
import android.content.res.Configuration
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.viewModelScope
import com.google.gson.Gson
import com.google.gson.JsonSyntaxException
import com.minedata.minenavi.mapdal.LatLng
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.BindResult
import com.sd.cavphmi.bean.CarAndStatu
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.bean.PerceptionBean
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.V2xStartBean
import com.sd.cavphmi.bean.VToXImgBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.bean.VehicleStats
import com.sd.cavphmi.bean.mock.MRoutes
import com.sd.cavphmi.bean.mock.MyCLoc
import com.sd.cavphmi.highmap.AllLine
import com.sd.cavphmi.highmap.HighMapApi
import com.sd.cavphmi.highmap.LockStatu
import com.sd.cavphmi.highmap.ParkStatu
import com.sd.cavphmi.highmap.Spinfo
import com.sd.cavphmi.highmap.WarnPtc
import com.sd.cavphmi.intfaces.OnWebSocketCb
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.net.RequestBodyUtil
import com.sd.cavphmi.net.SseCallback
import com.sd.cavphmi.net.SseMultiConnectionManager
import com.sd.cavphmi.repositorys.AvpDataRepo
import com.sd.cavphmi.utils.FileIoUtils
import com.sd.cavphmi.utils.MyContants
import com.sd.cavphmi.utils.MyContants.HTTP_TOKEN
import com.sd.cavphmi.utils.MyMapUtils
import com.sd.cavphmi.utils.ToastHelper
import com.sd.cavphmi.websockets.FeelTargetWSClient
import com.sd.cavphmi.websockets.V2xWSClient
import com.sd.cavphmi.websockets.VecLocWSClient
import commons.stand.FileSdCardUtils
import dagger.hilt.android.lifecycle.HiltViewModel
import dagger.hilt.android.qualifiers.ApplicationContext
import kotlinx.coroutines.delay
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.combine
import kotlinx.coroutines.launch
import java.net.URI
import javax.inject.Inject
import kotlin.coroutines.cancellation.CancellationException
import kotlin.math.absoluteValue


@HiltViewModel
class MainVm @Inject constructor(
    @ApplicationContext private var context: Context,
    private var avpDataRepo: AvpDataRepo
) : MyBaseViewModel() {

//    private var client: MyWebSocketClient? = null

    private val TAG = "MainVm"

//    var mMineMap: MineMap? = null

    //Windows 焦点
    var hasFocus = MutableLiveData<Boolean>()

    //Windows窗口变化
    var windowConfiguration = MutableLiveData<Configuration>()

    //用于拼接
    private val WSTOKEN = "&token=${HTTP_TOKEN}"

    //网联车辆位姿socket
    private var vecLocWSClient = VecLocWSClient(URI(MyContants.WS_VEH_LOC))

    //感知物socket
    private var feelTargetWSClient =
        FeelTargetWSClient(URI(MyContants.WS_FEEL_TARGET + WSTOKEN))

    //v2x预警socket
    private var v2xWSClient = V2xWSClient(URI(MyContants.WS_V2X + WSTOKEN))

    //网联车辆状态
//    private var vehStatuWSClient = VehStatuWSClient(URI(MyContants.WS_VEH_STATU))

    //socket 管理
    private var sockets = listOf(feelTargetWSClient, v2xWSClient)

    //交通信号灯
//    private var trafficLightWSClient: TrafficLightWSClient? = null

    private var gson = Gson()

    //模拟操作
    lateinit var mockVM: MockVM

    //是否需要模拟
    var isMock = false

    //车辆位姿数据
//    var carVehicle = MutableLiveData<CarVehicle>()
    var carVehicle = MutableStateFlow<CarVehicle>(CarVehicle())

    //avp状态数据
//    var avpStatu = MutableLiveData<AvpStatuBean>()
    var avpStatu = MutableSharedFlow<AvpStatuBean>(replay = 1)

    //合并车辆位姿和AVP
    var carAndAvp = carVehicle.combine(avpStatu) { carVeh, avpStatu ->
        CarAndStatu.getInstance().apply {
            carVehicle = carVeh
            avpStatuBean = avpStatu
        }
    }

    //车辆详情
    var vehDetail = MutableLiveData<VehDetailBean>()

    //是否获取过车辆详情
    var isGetVehDetail = false

    //感知目标物
    var targetPre = MutableLiveData<PerceptionBean>()

    //v2x 预警
    var v2xStartBean = MutableLiveData<V2xStartBean>()

    //联网车辆状态数据
    var vehicleStat = MutableLiveData<VehicleStats>()

    //车位占用情况
    var spaceInfo = MutableLiveData<SpaceInfoBean>()

    //获取已绑定车辆列表
    var bindCars = MutableLiveData<List<BindResult>>()


    /***清理资源***/
    fun cleanRes() {
        //关闭socket连接
        sockets.forEach {
            it.close()
        }
        //关闭Http sse 长连接
        SseMultiConnectionManager.instance.stopAllConnections()
    }


    //获取车辆详情 传{}就行，正常应该是传场地ID，但是亦庄这个和太和桥车是一样的,用于拿到车内视频
    fun getVehDetail(id: String = ""): LiveData<VehDetailBean> {
        if (isGetVehDetail)
            return vehDetail
        isGetVehDetail = true
        viewModelScope.launch {
            var result = avpDataRepo.getVehDetail(id)
            when (result) {
                is MyResult.Success<VehDetailBean> -> {
                    vehDetail.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return vehDetail
    }


    /* HTTP获取车位占用情况
     通过车位号传给四维高精地图*/
    fun getSpaceInfo(): LiveData<SpaceInfoBean> {
        viewModelScope.launch {
            var result = avpDataRepo.getSpaceInfo()
            when (result) {
                is MyResult.Success<SpaceInfoBean> -> {
                    var str = gson.toJson(result)
                    FileIoUtils.writeToFile(str, "space_info.txt")
                    spaceInfo.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return spaceInfo
    }

    //HTTP获取AVP状态
    fun getAvpStatus(): MutableSharedFlow<AvpStatuBean> {
        if (isMock) {
            mockVM.subAvpStatus(avpStatu)
        } else {
            var url = "${MyContants.HOST}/api/avpweb/hmi/monitor/v1/taskStatus"
            avpCb.url = url
            var body = RequestBodyUtil.toRequestBody(mapOf("id" to MyContants.VEHICLEID))
            avpDataRepo.getAvpStatus(url, body, avpCb)
        }
        return avpStatu
    }

    /***AVP状态回调***/
    private var avpCb = object : SseCallback {
        var url = ""

        override fun onConnected(connId: String) {
            println("-------- AVP状态  Sse open url = ${url}  connId = ${connId}")
        }

        override fun onEventReceived(
            connId: String,
            eventType: String?,
            data: String
        ) {
            viewModelScope.launch {
                if (data.isNotEmpty()) {
                    println("-------AVP状态 = ${data}")
                    try {
                        var result = gson.fromJson<AvpStatuBean>(data, AvpStatuBean::class.java)
                        if (result.haulingStageState != null) {//businessType
                            FileSdCardUtils.writeFileToDownload(data, "avp_status.txt")
                        }
                        avpStatu.emit(result)
                    } catch (e: JsonSyntaxException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        override fun onFailed(connId: String, errorMsg: String) {
            println("---------AVP 状态连接失败 connId = ${connId}   errorMsg = ${errorMsg}")
        }

        override fun onClosed(connId: String) {
            println("---------AVP 状态连接关闭 connId = ${connId}")
        }

        override fun onReconnecting(delayMillis: Long) {
            println("------ AVP ${delayMillis / 1000}秒后开始重连")
        }
    }


    /**
     * 联网车辆位姿数据
     */
    fun subVehicle(): StateFlow<CarVehicle> {
        if (isMock) {
//            mockVM.subVehicle(carVehicle)
//            mockVM.onVehicleMockPark(carVehicle)
            mockVM.onVehicleMockCall(carVehicle, targetPre)
        } else {
            var url = "${MyContants.HOST}/api/avpweb/hmi/monitor/v1/monitorDrivenStatus"
            carCb.url = url
            var body = RequestBodyUtil.toRequestBody(mapOf("id" to MyContants.VEHICLEID))
            avpDataRepo.getCarPose(url, body, carCb)
        }
        return carVehicle
    }


    //车辆位姿回调
    private var carCb = object : SseCallback {
        var url = ""
        override fun onConnected(connId: String) {
            println("--------车辆位姿  Sse open url = ${url}  connId = ${connId}")
        }

        override fun onEventReceived(
            connId: String,
            eventType: String?,
            data: String
        ) {
            viewModelScope.launch {
                if (data.isNotEmpty()) {
                    //                    println("-----车辆位姿 = ${data}")
                    try {
                        var result = gson.fromJson<CarVehicle>(data, CarVehicle::class.java)
                        if (result.vehiclePos != null) {
                            FileSdCardUtils.writeFileToDownload(data, "CarVehicle.txt")
                        }
                        carVehicle.value = result
                    } catch (e: JsonSyntaxException) {
                        e.printStackTrace()
                    }
                }
            }
        }

        override fun onFailed(connId: String, errorMsg: String) {
            println("---------车辆位置 连接失败 connId = ${connId}   errorMsg = ${errorMsg}")
        }

        override fun onClosed(connId: String) {
            println("---------车辆位置 状态连接失败 connId = ${connId}")
        }

        override fun onReconnecting(delayMillis: Long) {
            println("------ 车辆位置 ${delayMillis / 1000}秒后开始重连")
        }

    }


    /**感知目标物数据
     *传入intersectionCode=17 拼接 代表获取某区域的感知物，目前没有数据
     */
    fun subTarget(): LiveData<PerceptionBean> {
        if (isMock) {
            mockVM.onSubTargetMock(targetPre)
        } else {
            try {
                feelTargetWSClient!!.onWebSocketCb = object : OnWebSocketCb {
                    override fun onClose(
                        code: Int,
                        reason: String?,
                        remote: Boolean
                    ) {
                    }

                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            //下载到sd卡下面的DownLoad文件夹下面
                            if (str.isNotEmpty()) {
                                FileSdCardUtils.writeFileToDownload(str, "PerTarget.txt")
                                try {
                                    var bean = gson.fromJson(str, PerceptionBean::class.java)
                                    targetPre.postValue(bean)
                                } catch (e: JsonSyntaxException) {
                                    e.printStackTrace()
                                }
                            }
                        }
                    }
                }
                if (!feelTargetWSClient!!.isOpen) {
                    feelTargetWSClient?.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return targetPre
    }

    /**
     * V2X预警开始
     * 传入vehicleId 和url拼接代表某辆车的预警
     * 某个预警id要和感知物的ptcid对上
     */
    fun subStartV2x(): LiveData<V2xStartBean> {
        if (isMock) {
//            mockVM.onV2xMock(v2xStartBean)
        } else {
            try {
                v2xWSClient.onWebSocketCb = object : OnWebSocketCb {
                    override fun onClose(
                        code: Int,
                        reason: String?,
                        remote: Boolean
                    ) {
                    }

                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            if (str.isNotEmpty()) {
                                FileSdCardUtils.writeFileToDownload(str, "avp_v2x.txt")
                            }
                            try {
                                var bean = gson.fromJson(str, V2xStartBean::class.java)
                                v2xStartBean.postValue(bean)
                            } catch (e: JsonSyntaxException) {
                                e.printStackTrace()
                            }

                        }
                    }
                }
                if (v2xWSClient.isOpen == false) {
                    v2xWSClient.connect()
                }
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
        return v2xStartBean
    }


    //HTTP获取已绑定车辆列表
    fun getBindCar(): LiveData<List<BindResult>> {
        viewModelScope.launch {
            var result = avpDataRepo.getBindCar()
            when (result) {
                is MyResult.Success<List<BindResult>> -> {
//                    var str = gson.toJson(result)
//                    FileIoUtils.writeToFile(str, "bind_car.txt")
                    bindCars.postValue(result.data)
                }

                else -> {
                }
            }
        }
        return bindCars
    }


    //开启预警特效
    fun startWarning(ptcId: String) {
        viewModelScope.launch {
            var warnPtc = WarnPtc().apply {
                ptcid = ptcId
                isRed = true
            }
            var warns = listOf(warnPtc)
            HighMapApi.setWarnPtc(warns)
            delay(5000)
            warnPtc.isRed = false
            HighMapApi.setWarnPtc(warns)
        }
        toggleCircleRadar(2)
    }

    /**开启预警（光圈和雷达）
     * @param dirent  0=关闭  1=左前 2=正前 3=右前   4=右后  5=正后  6=左后
     * */
    fun toggleCircleRadar(dirent: Int) {
//        HighMapApi.setCarBottomCircle(true)
        HighMapApi.setCarRadarDirection(dirent)
        viewModelScope.launch {
            delay(MyContants.WARNINGTIME)
//            HighMapApi.setCarBottomCircle(false)
            HighMapApi.setCarRadarDirection(0)
        }
    }

// 模拟---------------
// 模拟---------------------------
// 模拟-----------

    //模拟在仿真路上跑
    fun mockFzLine() {
        viewModelScope.launch {
            try {
                var gson = Gson()
                var str =
                    FileIoUtils.getAsset(context, "mock/Car_fangzhen.txt")   //Qgis里取的点和四维取得点混合
                val carVehicle = gson.fromJson<MRoutes>(str, MRoutes::class.java)
                //画出全局路径
                var lines = carVehicle.rs.map {
                    AllLine(it[1], it[0])
                }
                HighMapApi.setCarNavPath(lines, showdistance = 200)
                //开启流光效果
                HighMapApi.parkRoundLight("B021")
                //2旁车辆占用
                var spinfos = listOf(Spinfo().apply {
                    code = "B020"
                    state = true
                }, Spinfo().apply {
                    code = "B022"
                    state = true
                })
                HighMapApi.setParkStatu(ParkStatu(spinfos))
                //模拟车辆移动
                var head = 0.0
                var oldHead = 0.0
                var bearing = 0f
                carVehicle.rs.forEachIndexed { index, it ->
                    if (index > 0 && index < carVehicle.rs.count()) {
                        var p1 = carVehicle.rs.get(index - 1)
                        var pc = carVehicle.rs.get(index)
                        head = MyMapUtils.calculateBearing(
                            LatLng(p1[1], p1[0]),
                            LatLng(pc[1], pc[0])
                        )
                    }
                    var myloc = MyCLoc.instance.apply {
                        lat = it[1]
                        lng = it[0]
                        if ((head - oldHead).absoluteValue < 45) {
                            this.bearing = head.toFloat()
                        }
                        //   println("-----bearing = ${bearing}")
                        //高程
                        altitude = 20.802828
                    }
                    oldHead = head
                    HighMapApi.setCarPosition(
                        myloc.bearing.toDouble(),
                        myloc.lat,
                        myloc.lng,
                        myloc.altitude,
                    )
                    delay(300)
                }
                //地锁绘制
                var lockStatu = LockStatu().apply {
                    code = "B021"
                    up = false
                }
                HighMapApi.setLockStatus(lockStatu)
                delay(5000)
                lockStatu.isHide = true
                HighMapApi.setLockStatus(lockStatu)
                //消除全局路径
                HighMapApi.setCarNavPath(listOf())
            } catch (e: CancellationException) {

            }
        }
    }

    //预警车
    fun mWarnCar() {
        //气泡消息
        v2xStartBean.value = V2xStartBean().apply { type = 1 }
        startWarning("f117fdfa-feff-0100-85dc-35850000acb0")
    }

    //预警人
    fun mWarnPeo() {
        //气泡消息
        v2xStartBean.value = V2xStartBean().apply { type = 12 }
        startWarning("50332456-3030-3030-3530-303334533955")
    }

    /**
     * 网联车辆状态
     **/
    /*   fun subVehicleStatus(): LiveData<VehicleStats> {
           if (isMock) {

           } else {
               try {
                   vehStatuWSClient.onDataCb = object : VehStatuWSClient.OnDataCb {
                       override fun onMsg(str: String) {
                           viewModelScope.launch {
                               FileIoUtils.writeToFile(str, "vehicleS.txt")
                               var bean = gson.fromJson(str, VehicleStats::class.java)
                               vehicleStat.postValue(bean)
                           }
                       }
                   }
                   if (vehStatuWSClient.isOpen == false) {
                       vehStatuWSClient.connect()
                   } else {
                       vehStatuWSClient.reconnect()
                   }
               } catch (e: Exception) {
                   e.printStackTrace()
               }
           }
           return vehicleStat
       }*/


//暂时用不到---------------------------------------------


    /*** 交通（感知）事件**//*
    fun subTrafficPre(): LiveData<TrafficPerBean> {
        try {
            if (trafficPreWSClient == null) {
                trafficPreWSClient = TrafficPreWSClient(URI(MyContants.WS_TRAFFIC_PER))
                trafficPreWSClient?.connect()

                trafficPreWSClient?.onDataCb = object : TrafficPreWSClient.OnDataCb {
                    override fun onMsg(str: String) {
                        viewModelScope.launch {
                            FileIoUtils.writeToFile(str, "pre_traff.txt")
                            var bean = gson.fromJson(str, TrafficPerBean::class.java)
                            trafficPerBean.postValue(bean)
                        }
                    }
                }
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return trafficPerBean
    }


    */
    fun showVToTip() {
        var imgs = VToXImgBean.imgs
        ToastHelper.showCustViewShort(context, imgs.get("2")!!)
    }


    /*fun d1() {
        try {
            vecLocWSClient.onWebSocketCb = object : OnWebSocketCb {
                override fun onClose(code: Int, reason: String?, remote: Boolean) {
                }

                override fun onMsg(str: String) {
                    viewModelScope.launch {
                        //下载到sd卡下面的DownLoad文件夹下面
                        if (str.isNotEmpty()) {
                            FileIoUtils.writeToFile(str, "CarVehicle.txt")
                        }
                        var carBean = gson.fromJson(str, CarVehicle::class.java)
                        //更新主车位置
                        carVehicle.postValue(carBean)
                    }
                }
            }
            if (!vecLocWSClient.isOpen) {
                vecLocWSClient.connect()
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }*/


}