package com.sd.cavphmi.utils

import com.sd.cavphmi.bean.DrivenDecision
import commons.gis.MGeoTools
import org.locationtech.jts.geom.LineString
import org.locationtech.jts.geom.Polygon


object MyGeoTools {

    // 创建 GeometryFactory
//    private var geometryFactory: GeometryFactory = GeometryFactory()

    //全局路径生成线段
    fun genLine(drivenDecision: DrivenDecision): LineString {
        val lines = drivenDecision.trajectory.points.map {
//            Coordinate(it.longitude, it.latitude)
            listOf(it.longitude, it.latitude)
        }
//        var lineString = geometryFactory.createLineString(lines)
        var lineString = MGeoTools.createLine(lines)
        return lineString
    }

    //计算线段里的点是否在面里
    fun cauLineContainsArea(polygon: Polygon?, lineString: LineString?): Int {
        if (polygon == null || lineString == null) {
            return 0
        }
        lineString.coordinates.forEachIndexed { index, cood ->
//            val sinPoint = geometryFactory.createPoint(cood)
            val sinPoint = MGeoTools.createPoint(cood.x, cood.y)
            if (polygon.contains(sinPoint)) {
                return index
            }
        }
        return 0
    }


    //根据坐标生成前方矩形
/*    fun genFontArea(
        lng: Double, lat: Double, heading: Double, length: Double = 10.0,
        width: Double = 3.0
    ): Polygon {
        var rectanglePoints = GeoRectangleUtils.createRectangleInFront(listOf(lng, lat), heading)

        val coordinates = rectanglePoints.map {
            Coordinate(it[0], it[1])
        }.toMutableList()
//        var one = myRectangle.corners.first()
//        coordinates.add(Coordinate(one[0], one[1]))
        var polygon = geometryFactory.createPolygon(coordinates.toTypedArray())
        return polygon
    }*/

    // z根据中心点生成指定方向的矩形
   /* fun genRectangleFromCenter(
        lng: Double, lat: Double, heading: Double, length: Double = 10.0,
        width: Double = 3.0
    ): Polygon {
//        var rectanglePoints = GeoRectangleUtils.createRectangleFromCenter(lng,lat)
        var rectanglePoints = GeoRectangleUtils.generateCenterRect(lng,lat,heading)

        val coordinates = rectanglePoints.map {
            Coordinate(it[0], it[1])
        }.toMutableList()
//        var one = myRectangle.corners.first()
//        coordinates.add(Coordinate(one[0], one[1]))
        var polygon = geometryFactory.createPolygon(coordinates.toTypedArray())
        return polygon
    }*/



}