package com.sd.cavphmi.ui.fragment

import android.os.Bundle
import androidx.lifecycle.ViewModelProvider
import androidx.media3.common.AudioAttributes
import androidx.media3.common.MediaItem
import androidx.media3.common.PlaybackException
import androidx.media3.common.Player
import androidx.media3.exoplayer.ExoPlayer
import com.sd.cavphmi.BR
import com.sd.cavphmi.R
import com.sd.cavphmi.base.BaseFragment
import com.sd.cavphmi.base.MyBaseViewModel
import com.sd.cavphmi.databinding.FragmentExoPlayBinding


// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val VIDEO_URL = "videoUrl"
private const val ARG_PARAM2 = "param2"

/**
 *车内视频播放器
 */
class ExoPlayFragment : BaseFragment<FragmentExoPlayBinding, MyBaseViewModel>() {

//    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            videoUrl = it.getString(VIDEO_URL, "")
//            param2 = it.getString(ARG_PARAM2)
        }
    }

    override fun getStatuBarColor(): Int {
        return -1
    }


    override fun isAutoStatusBarDarkModeEnable(): Boolean {
        return false
    }

    override fun initContentView(): Int {
        return R.layout.fragment_exo_play
    }

    override fun initViewModel(): MyBaseViewModel {
        return ViewModelProvider(this).get(MyBaseViewModel::class.java)
    }

    override fun initVariableId(): Int {
        return BR.vm
    }

    override fun onResume() {
        super.onResume()
        binding.playerView.onResume()
    }

    override fun onPause() {
        super.onPause()
        binding.playerView.onPause()
    }

    override fun onDestroy() {
        super.onDestroy()
//        binding.playerView.getAdViewGroup().removeAllViews()
        releasePlayer()
    }

    private var player: ExoPlayer? = null

//     var videoUrl = "https://itg-yz.cu-sc.com:13443/video/yizhuang/0b130981fd754f7e817797235f399264.live.flv"
    var videoUrl = ""

    //用于测试，实际可以传参进来
//    private var videoUri = "https://faw.cuscavp.cn:8443/hdl/live/3.flv"

    override fun initView() {
//        DisplayUtil.forceMeasure(binding.playerView)
        // 重要：必须使用 texture_view 才能显示圆角
        binding.playerView.apply {
//            setShutterBackgroundColor(Color.TRANSPARENT)
//            clipToOutline = true
//            clipChildren=true
//            outlineProvider = object : ViewOutlineProvider() {
//                override fun getOutline(view: View, outline: Outline) {
//                    outline.setRoundRect(10, 200,400,  800, 40f)
//                }
//            }
//            setBackgroundResource(R.drawable.rect_no_col_10)
        }
        initializePlayer()
    }

    fun initializePlayer() {
        if (player == null) {
            val playerBuilder =
                ExoPlayer.Builder(requireContext())
                    .setMediaSourceFactory(createMediaSourceFactory())

            player = playerBuilder.build()
            player!!.addListener(playerEventListener)
            player?.setAudioAttributes(AudioAttributes.DEFAULT, /* handleAudioFocus= */ true);
            player?.setPlayWhenReady(true)
            binding.playerView.setPlayer(player)

            // Build the media item.
            val mediaItem = MediaItem.Builder()
                .setUri(videoUrl)
                .setLiveConfiguration(
                    MediaItem.LiveConfiguration.Builder()
                        .setMaxPlaybackSpeed(1.02f)
                        .setMinPlaybackSpeed(0.9f)
                        .build()
                )
                .build()

            player?.setMediaItem(mediaItem)
            player?.prepare()
        }
        // Start the playback.
//        player.play()
    }


    fun releasePlayer() {
        binding.playerView.setPlayer(/* player= */ null)
        player?.release()
        player = null
    }


    private var playerEventListener = object : Player.Listener {
        override fun onPlayerError(error: PlaybackException) {
            super.onPlayerError(error)
            println("------ExoPlayFragment.onPlayerError = ${error.message}")
        }

        override fun onPlaybackStateChanged(playbackState: Int) {
            super.onPlaybackStateChanged(playbackState)
            when (playbackState) {
                Player.STATE_READY -> {
                    // 播放器准备好时隐藏占位图
//                    placeholderImage.visibility = View.GONE
                }
                Player.STATE_BUFFERING, Player.STATE_IDLE -> {
                    // 缓冲或空闲时显示占位图
//                    placeholderImage.visibility = View.VISIBLE
                }
            }
        }

        override fun onPlayWhenReadyChanged(playWhenReady: Boolean, reason: Int) {
            super.onPlayWhenReadyChanged(playWhenReady, reason)
            println("------ExoPlayFragment playWhenReady = ${playWhenReady}")

        }

        override fun onRenderedFirstFrame() {
            super.onRenderedFirstFrame()
            println("------ExoPlayFragment.onRenderedFirstFrame")
        }
    }


    companion object {
        @JvmStatic
        fun newInstance() = ExoPlayFragment()
//        @JvmStatic
//        fun newInstance(videoUrl: String) =
//            ExoPlayFragment().apply {
//                arguments = Bundle().apply {
//                    putString(VIDEO_URL, videoUrl)
//                }
//            }
    }
}