package com.sd.cavphmi.ui.fragment

import android.os.Bundle
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.core.graphics.toColorInt
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.repeatOnLifecycle
import com.sd.cavphmi.bean.AvpStatuBean
import com.sd.cavphmi.bean.CarVehicle
import com.sd.cavphmi.databinding.FragmentDistantTipBinding
import com.sd.cavphmi.utils.AvpContants
import com.sd.cavphmi.viewmodels.MainVm
import commons.gis.BasicTools
import kotlinx.coroutines.launch

// the fragment initialization parameters, e.g. ARG_ITEM_NUMBER
private const val ARG_PARAM1 = "param1"
private const val ARG_PARAM2 = "param2"

/**
 *距离提示
 */
class DistantTipFragment : Fragment() {
    private var param1: String? = null
    private var param2: String? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            param1 = it.getString(ARG_PARAM1)
            param2 = it.getString(ARG_PARAM2)
        }
    }


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?
    ): View? {
        binding = FragmentDistantTipBinding.inflate(inflater, container, false)
        return binding.root
        // Inflate the layout for this fragment
//        return inflater.inflate(R.layout.fragment_distant_tip, container, false)
    }

    private lateinit var binding: FragmentDistantTipBinding

    //主页操作
    private val mainVm: MainVm by activityViewModels()

    private val spannableString = SpannableStringBuilder()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        //观察AVP状态
//        mainVm.avpStatu.observe(viewLifecycleOwner) {
//            showTip(it)
//        }
        lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.STARTED) {
                mainVm.carAndAvp.collect { carAndAvp ->
                    if (carAndAvp.carVehicle == null || carAndAvp.avpStatuBean == null) {
                        return@collect
                    }
                    showTip(carAndAvp.avpStatuBean!!, carAndAvp.carVehicle!!)
                }
            }
        }
    }

    //展示提示文字
    private fun showTip(avpStatu: AvpStatuBean, car: CarVehicle) {
        //业务类型
        var businessType = avpStatu.businessType//NIL Park Call
        //业务状态
        var businessStatus = avpStatu.haulingStageState
        lifecycleScope.launch {
//            val vehicleDynamic = avpStatu.vehicleContext.vehicleDynamic
            if (avpStatu.drivenDecision == null)
                return@launch
            val endPoint = avpStatu.drivenDecision.trajectory.endPoint
            //计算车到终点的距离
            var distance = BasicTools.calculateHaversineDistance(
                car.vehiclePos?.get(0) ?: 0.0,
                car.vehiclePos?.get(1) ?: 0.0,
                endPoint.longitude,
                endPoint.latitude
            ).toInt()
//            var distance = MyMapUtils.cauMyLocDistance(
//                vehicleDynamic.latitude,
//                vehicleDynamic.longitude,
//                endPoint.latitude,
//                endPoint.longitude
//            ).toInt()

            if (businessType == AvpContants.Park_TYPE) {
                when (businessStatus) {
                    AvpContants.TRANSPORT_PROGRESS -> {
                        takeStr(distance, 1)
                    }

                    AvpContants.TRANSPORT_COMPLETED, AvpContants.TRANSPORT_CANCELED, AvpContants.TRANSPORT_ABNORMAL -> {
                        clearTipStr()
                    }
                }
            } else if (businessType == AvpContants.CALL_TYPE) {
                when (businessStatus) {
                    AvpContants.TRANSPORT_PROGRESS -> {
                        takeStr(distance, 2)
                    }

                    AvpContants.TRANSPORT_COMPLETED, AvpContants.TRANSPORT_CANCELED, AvpContants.TRANSPORT_ABNORMAL -> {
                        clearTipStr()
                    }
                }
            }

        }
    }

    /**
     * 生成提示字符串
     * @param x 1=泊车 2=招车
     */
    private fun takeStr(distance: Int, x: Int) {
//        if (distance < 3) {
//            clearTipStr()
        spannableString.clear()
//            return
//        }
        if (x == 1) {
            spannableString.append("正在前往您的车位,距离终点${distance}m")
        } else if (x == 2) {
            spannableString.append("正在前往您召车点,距离乘客${distance}m")
        }
        var colorSpan1 = ForegroundColorSpan("#000000".toColorInt())
        spannableString.setSpan(
            colorSpan1, 0, 12,  // 起始索引
            Spannable.SPAN_INCLUSIVE_INCLUSIVE  // 范围模式
        )

        var colorSpan2 = ForegroundColorSpan("#3385FE".toColorInt())
        spannableString.setSpan(
            colorSpan2, 13, spannableString.count(), Spannable.SPAN_INCLUSIVE_EXCLUSIVE
        )
        binding.tvTip.text = spannableString
    }

    //清除提示字符串
    private fun clearTipStr() {
        spannableString.clear()
        binding.tvTip.text = ""
    }

    private fun testStr() {
        val text = "正在前往您的车位,距离终点6m"

        val spannableString = SpannableStringBuilder().append(text)

//        val spannableString = SpannableString(text)
        var colorSpan1 = ForegroundColorSpan("#000000".toColorInt())
        spannableString.setSpan(
            colorSpan1, 0, 12,  // 起始索引（包含）、结束索引（不包含）
            Spannable.SPAN_INCLUSIVE_INCLUSIVE  // 范围模式（见下文说明）
        )

        var colorSpan2 = ForegroundColorSpan("#3385FE".toColorInt())
        spannableString.setSpan(
            colorSpan2, 13, spannableString.count(),  // 起始索引（包含）、结束索引（不包含）
            Spannable.SPAN_INCLUSIVE_EXCLUSIVE  // 范围模式（见下文说明）
        )
        binding.tvTip.text = spannableString
    }

    companion object {
        @JvmStatic
        fun newInstance() = DistantTipFragment()
    }

}