package com.sd.cavphmi.repositorys

import com.sd.cavphmi.bean.BindResult
import com.sd.cavphmi.bean.SpaceInfoBean
import com.sd.cavphmi.bean.VehDetailBean
import com.sd.cavphmi.bean.req.SpaceInfo
import com.sd.cavphmi.net.MyResult
import com.sd.cavphmi.net.RequestBodyUtil
import com.sd.cavphmi.net.SseCallback
import com.sd.cavphmi.net.SseManager
import com.sd.cavphmi.net.SseManager.SseCallback2
import com.sd.cavphmi.net.SseMultiConnectionManager
import com.sd.cavphmi.net.httpmothod.ClientRetrofitMethod
import com.sd.cavphmi.utils.MyContants
import okhttp3.RequestBody
import retrofit2.HttpException
import javax.inject.Inject

/**AVP 接口**/
class AvpDataRepo @Inject constructor(
    private var retrofitMethod: ClientRetrofitMethod
) {

//    private var simpleSSEClient = SimpleSSEClient.instance
    private var sseManager2 = SseManager.instance
    // 初始化多连接管理器（全局单例更佳，可通过依赖注入）
    private val sseManager = SseMultiConnectionManager.instance

    // 连接 ID 定义（唯一标识每个连接）
    private val CONN_ID_CAR = "CAR"       // 聊天连接
    private val CONN_ID_AVPSTATU = "AVP_STATU"   // 系统通知连接

    /**获取车辆详情
     * @param id 正常应该是传场地ID，但是亦庄这个和太和桥车是一样的
     */
    suspend fun getVehDetail(id: String = ""): MyResult<VehDetailBean> {
//        var map = mapOf("id" to id)
//        var map = mapOf()
        var body = RequestBodyUtil.toRequestBody(mapOf())
        try {
            var bean = retrofitMethod.getVehDetail(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取车位占用情况
     */
    suspend fun getSpaceInfo(): MyResult<SpaceInfoBean> {
        try {
            var spaceInfo = SpaceInfo().apply {
                state = 1
            }
            var body = RequestBodyUtil.toRequestBody(spaceInfo)
            var bean = retrofitMethod.getSpaceInfo(body)
            return MyResult.Success(bean)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取可绑车辆
     */
    suspend fun getBindCar(): MyResult<List<BindResult>> {
        try {
//            var body = RequestBodyUtil.toRequestBody(mapOf())
            var bean = retrofitMethod.getBindCar()
            return MyResult.Success(bean.result)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }


    /**登录***/
    suspend fun login(user: String, pwd: String, verifyCode: Int): MyResult<String> {
//        if (id.isNullOrEmpty()) {
//            return MyResult.Error(MyContants.HTTP_ERROR, "error")
//        }
        var map = mapOf("username" to user, "password" to pwd, "verifyCode" to verifyCode)

        var body = RequestBodyUtil.toRequestBody(map)
        try {
            var bean = retrofitMethod.login(body)
            return MyResult.Success(bean.result.token)
        } catch (e: HttpException) {
//                println("e.message = ${e.message}")
            return MyResult.Error(e.code(), e.message() ?: "error")
        } catch (e: Exception) {
            return MyResult.Error(MyContants.HTTP_ERROR, e.message ?: "error")
        }
    }

    /**
     * 获取AVP状态信息
     * 我们车辆位姿数据用的是 车俩基础信息的id   可绑车辆接口 返回的是 avp车俩id
     * 所以这里的id 是绑定车辆列表返回的id
     */
    fun getAvpStatus(url: String, body: RequestBody, sseCallback: SseCallback) {
        sseManager.startConnection(CONN_ID_AVPSTATU, url, body, sseCallback)

       /* sseManager2.addListener(object : SseCallback2 {
            override fun onConnected() {
                println("------------getAvpStatus  onConnected")
            }

            override fun onDisconnected() {
            }

            override fun onMessageReceived(data: String, eventType: String) {
                println("----------getAvpStatus = ${data}")
            }

            override fun onError(errorMsg: String, throwable: Throwable?) {
                println("------------getAvpStatus  errorMsg")
            }

            override fun onReconnecting(delayMillis: Long) {
            }
        })
        sseManager2.connect(url, body)*/
    }

    /**获取车辆位姿****/
    fun getCarPose(url: String, body: RequestBody, sseCallback: SseCallback) {
        sseManager.startConnection(CONN_ID_CAR, url, body, sseCallback)
    }


}