package com.sd.cavphmi.bean

/**
 * Avp 状态信息
 * {"haulingNo":"PARK-202511263","vin":"LU123456789011111","spaceId":"1594179823000223754","space":{"id":1594179823000223754,"createdAt":1693016363,"updatedAt":1764137952156,"name":"B002","code":"1567","state":"OCCUPY","spaceType":"PARK","surface":"[[116.502672641583686,39.808717348607381],[116.502656697557583,39.808737040046204],[116.502719621229957,39.808767724154123],[116.502735514232526,39.808748008315952],[116.502672641583686,39.808717348607381]]","entranceLongitude":116.50274476891985,"entranceLatitude":39.808767558388645,"centerLongitude":120.7066859236955,"centerLatitude":31.324335727750118,"elevation":null,"occupyTime":"2025-11-26T06:19:12.139Z","occupySource":"LOCK","placeId":1,"line":null},"haulingStageState":"TRANSPORT_PROGRESS","businessType":"Park","vehicleContext":{"vin":"LU123456789011111","vehicleBusinessType":null,"online":true,"vehicleBasic":{"id":27,"deviceId":"0102072022380026","vehicleLength":null,"vehicleWidth":null,"maxSpeed":null,"minTurnRadius":null},"vehicleDynamic":{"speed":0.006823937919616057,"accSpeed":9.98458292271517,"longitude":116.502475,"latitude":39.809097,"elevation":23.00799999999981,"heading":148.6669921875,"drivingMode":"MANUAL","gearType":"PARK","power":null,"doorStatus":"1111111","light":null,"wiper":null},"perceptionContext":null},"drivenDecision":{"startPoint":{"id":"8b437b15-eb41-45d5-a1e4-d086dd5e62fd","longitude":116.502475,"latitude":39.809097,"altitude":23.00799999999981,"heading":148.6669921875,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},"endPoint":{"id":"1567","longitude":116.50274476891985,"latitude":39.808767558388645,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},"trajectory":{"arrived":false,"startPoint":{"id":null,"longitude":0.0,"latitude":0.0,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},"endPoint":{"id":null,"longitude":116.50274476891985,"latitude":39.808767558388645,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},"points":[{"id":null,"longitude":116.50248899270137,"latitude":39.80910810251742,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},{"id":null,"longitude":116.50250735122155,"latitude":39.80908496494593,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null},{"id":null,"longitude":116.50275529593338,"latitude":39.808776006506584,"altitude":0.0,"heading":0.0,"targetSpeed":0.0,"acceleration":0.0,"timestamp":0.0,"curvature":0.0,"curvatureRate":0.0,"area":null,"longitudinalAcce":null,"longitudinalDis":null,"longitudinalSpeed":null,"transverseAcce":null,"transverseDis":null,"transverseSpeed":null,"verticalAcce":null}],"pathLine":"1471_0.0000_-1,1457_0.0000_-1,1432_0.0000_-1,1348_0.0000_1,1450_0.0000_-1,1456_0.0000_-1,1487_0.0000_-1,1457_0.0000_1","pathArray":null,"length":56.522754903940324,"time":40},"routing":null,"progress":null},"exceptionCode":null,"exceptionMessage":null}
 *
 */
data class AvpStatuBean(
    val businessType: String,
    val drivenDecision: DrivenDecision,
//    val exceptionCode: Any,
//    val exceptionMessage: Any,
    val haulingNo: String,
    val haulingStageState: String,
    val space: Space,
    val spaceId: String,
    val vehicleContext: VehicleContext,
    val vin: String
)

data class DrivenDecision(
    val endPoint: EndPoint,//终点
//    val progress: Any,
//    val routing: Any,
    val startPoint: StartPoint,//起点
    val trajectory: Trajectory //// 全局路径
)

//车位信息
data class Space(
    val centerLatitude: Double,
    val centerLongitude: Double,
    val code: String,
//    val createdAt: Long,
//    val elevation: Any,
    val entranceLatitude: Double,
    val entranceLongitude: Double,
    val id: Long,
//    val line: Any,
    val name: String,
//    val occupySource: String,
//    val occupyTime: String,
    val placeId: Int,
    val spaceType: String,
    val state: String,
    val surface: String,
    val updatedAt: Long
)

data class VehicleContext(
    val online: Boolean,
//    val perceptionContext: Any,
    val vehicleBasic: VehicleBasic,
    val vehicleBusinessType: String,
    val vehicleDynamic: VehicleDynamic,
    val vin: String
)

data class EndPoint(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: String,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class StartPoint(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: String,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

// 全局路径
data class Trajectory(
    val arrived: Boolean,
    val endPoint: EndPointX,
    val length: Double,
    val pathArray: Any,
    val pathLine: String,
    val points: List<Point>,// 全局路径 02坐标系
    val startPoint: StartPointX,
    val time: Int
)

data class EndPointX(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class Point(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class StartPointX(
    val acceleration: Double,
    val altitude: Double,
    val area: Any,
    val curvature: Double,
    val curvatureRate: Double,
    val heading: Double,
    val id: Any,
    val latitude: Double,
    val longitude: Double,
    val longitudinalAcce: Any,
    val longitudinalDis: Any,
    val longitudinalSpeed: Any,
    val targetSpeed: Double,
    val timestamp: Double,
    val transverseAcce: Any,
    val transverseDis: Any,
    val transverseSpeed: Any,
    val verticalAcce: Any
)

data class VehicleBasic(
    val deviceId: String,
    val id: Int,
    val maxSpeed: Any,
    val minTurnRadius: Any,
    val vehicleLength: Any,
    val vehicleWidth: Any
)

data class VehicleDynamic(
    val accSpeed: Double,
    val doorStatus: String,
    val drivingMode: String,
    val elevation: Double,
    val gearType: String,
    val heading: Double,
    val latitude: Double,
    val light: Any,
    val longitude: Double,
    val power: Any,
    val speed: Double,
    val wiper: Any
)