package com.sd.cavphmi.adapter

//import kotlinx.android.synthetic.main.poi_search_list_item.view.*
import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter4.BaseQuickAdapter
import com.sd.cavphmi.bean.WarningBean
import com.sd.cavphmi.databinding.WarnListItemBinding
import javax.inject.Inject


/**
 *预警适配器
 *
 */
class WarnAdapter @Inject constructor() :
    BaseQuickAdapter<WarningBean, WarnAdapter.WarnVH>() {

    init {
//        addChildClickViewIds(R.id.tv_fouc)
    }

    private var orientation = 0

    fun setMyOrientation(orientation: Int) {
        this.orientation = orientation
    }


    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): WarnVH {
        return WarnVH(parent)
    }

    override fun onBindViewHolder(
        holder: WarnVH,
        position: Int,
        item: WarningBean?
    ) {
        holder.show(item!!)
    }

    inner class WarnVH(
        parent: ViewGroup,
        val binding: WarnListItemBinding = WarnListItemBinding.inflate(
            LayoutInflater.from(parent.context),
            parent,
            false
        )
    ) : RecyclerView.ViewHolder(binding.root) {

        private var roadWarn = binding.roadWarn

        fun show(wb: WarningBean) {
            roadWarn.setMyOrientation(orientation)
            roadWarn.setWarnBean(wb)
        }

        fun setListener() {
//            tv_fouc.clicks().throttleFirst(1, TimeUnit.SECONDS).subscribe {
//                focusOn(layoutPosition)
//            }
        }
    }

//    override fun onBindViewHolder(holder: WarnVH, position: Int, item: WarnVH) {
//        holder.show(item)
//    }


}