package com.sd.cavphmi.utils

import android.graphics.Point
import com.minedata.minenavi.mapdal.LatLng
import com.minedata.minenavi.util.Tools

object AvpMapUtils {

    //找到离车最近点的下标
    suspend fun findNearPointIndex(
        point: LatLng,
        sLatLngs: List<Point>
    ): Int {
        var minDistance = Double.Companion.MAX_VALUE
        var nearestIndex = -1

        var series = sLatLngs.map {
            Tools.pointToLatLng(it)
        }
        //获取起点和终点
        var sPoi = series.first()
        var ePoi = series.last()
        //离起点距离
        var sDis =
            MyMapUtils.cauMyLocDistance(
                point.longitude, point.latitude,
                sPoi.longitude, sPoi.latitude
            )
        //        println("---------------distance = ${distance}")
        //线段长度
        var lineSeg = MyMapUtils.cauMyLocDistance(
            sPoi.longitude, sPoi.latitude,
            ePoi.longitude, ePoi.latitude
        )

        if (sDis > lineSeg * 2) {
            return 0
        }
        series.forEachIndexed { index, latLng ->
            val distance = MyMapUtils.cauMyLocDistance(
                point.longitude,
                point.latitude,
                latLng.longitude,
                latLng.latitude
            )
//            println("---------distance = ${distance}  index = ${index}")
            if (distance < minDistance) {
                minDistance = distance
                nearestIndex = index
            }
        }
        return nearestIndex
    }
}