package com.sd.cavphmi.ui

import android.content.Intent
import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.repeatOnLifecycle
import com.jakewharton.rxbinding4.view.clicks
import com.sd.cavphmi.bean.BindResult
import com.sd.cavphmi.databinding.ActivityLoginBinding
import com.sd.cavphmi.ui.dialog.SeleBindCarDialog
import com.sd.cavphmi.utils.MMKVUtil
import com.sd.cavphmi.utils.MyContants
import com.sd.cavphmi.viewmodels.LoginVm
import com.sd.cavphmi.viewmodels.MainVm
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.launch
import java.util.concurrent.TimeUnit

@AndroidEntryPoint
class LoginActivity : AppCompatActivity() {

    private lateinit var binding: ActivityLoginBinding

    private val loginVm: LoginVm by viewModels()
    private val mainVm: MainVm by viewModels()

    private val PWD = "5803d205ac27f33ea5f53afed4eb81880bee49f06129ea5437c1b940d18da8f1"
    private val VERIFYCODE = 285369

    //车牌号选择
//    private lateinit var seleBindCarDialog: SeleBindCarDialog
    private val seleBindCarDialog: SeleBindCarDialog by lazy { SeleBindCarDialog.newInstance() }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLoginBinding.inflate(layoutInflater)
        setContentView(binding.root)

   /*     if (MMKVUtil.token.isNotEmpty()) {
            MyContants.HTTP_TOKEN = MMKVUtil.token
            getBinderCars()
        }*/
//        else {
        var lo = binding.btLogin.clicks().throttleFirst(1, TimeUnit.SECONDS).subscribe {
            login()
        }
//        }
        setListener()
    }

    private fun login() {
//        seleBindCarDialog.setPlates(plateNumbers)
//            seleBindCarDialog.showNow(supportFragmentManager, "seleBindCarDialog")
//        return
        var user = binding.etAccount.text.toString()
//                var pwd = binding.etPwd.text.toString()
//            "4CIHV37pDF8sx0ZXYmYah6HSgys7F7ULSMmm39uzppc"
//            var key = "Cusc@itmp-sm4key".toByteArray()
//            var pp = SM4CryptoHelper.encryptECB(key, pwd.toByteArray())
        lifecycleScope.launch {
            repeatOnLifecycle(Lifecycle.State.STARTED) {
                loginVm.login(user, PWD, VERIFYCODE).collect {
//                    println("-----------登录回调 = ${it}")
                    //获取可绑定车辆
                /*    if (it == 1) {
                        getBinderCars()
                    }*/
                    startActivity(Intent(this@LoginActivity, MainActivity::class.java))
                    finish()
                }
            }
        }
    }

    private fun setListener() {
        //  HTTP获取车位占用情况
        binding.btSpaceinfo.setOnClickListener {
            mainVm.getSpaceInfo()
        }
        //  HTTP获取AVp状态信息 以后就用socket订阅了,获取找、泊车状态，拿到全局路径lines,和局部（避障）路径xxx
        binding.btAvpstatu.setOnClickListener {
            mainVm.getAvpStatus()
        }
        binding.btCarpos.setOnClickListener {
            mainVm.subVehicle()
        }
        //获取可绑定车辆
        binding.btGetbindcar.setOnClickListener {
            getBinderCars()
        }
        //直接到首页
        binding.btMain.setOnClickListener {
            startActivity(Intent(this, MainActivity::class.java))
            finish()
        }
    }


    //获取可绑定车辆
    private fun getBinderCars() {
        if (mainVm.isMock) {
            //id = 27
            var bindCars = listOf(BindResult(27, "皖BDJ1106"))
            var plateNumbers = bindCars.map { it.plateNumber }
            seleBindCarDialog.setPlates(plateNumbers)
            seleBindCarDialog.itemClickListener =
                object : SeleBindCarDialog.OnItemClickListener {
                    override fun onItemClick(position: Int) {
                        MyContants.VEHICLEID = bindCars.get(position).id
                        startActivity(Intent(this@LoginActivity, MainActivity::class.java))
                        finish()
                    }
                }
        } else {
            mainVm.getBindCar().observe(this) { bindCars ->
                var plateNumbers = bindCars.map { it.plateNumber }
                seleBindCarDialog.itemClickListener =
                    object : SeleBindCarDialog.OnItemClickListener {
                        override fun onItemClick(position: Int) {
                            MyContants.VEHICLEID = bindCars.get(position).id
                            startActivity(Intent(this@LoginActivity, MainActivity::class.java))
                            finish()
                        }
                    }
                seleBindCarDialog.setPlates(plateNumbers)
            }
        }
        if (!seleBindCarDialog.isAdded) {
            seleBindCarDialog.showNow(supportFragmentManager, "seleBindCarDialog")
        }
    }


}