package com.sd.cavphmi.net

import android.os.Handler
import android.os.Looper
import com.sd.cavphmi.moudule.NetworkModule
import okhttp3.ConnectionPool
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.RequestBody
import okhttp3.Response
import okhttp3.sse.EventSource
import okhttp3.sse.EventSourceListener
import okhttp3.sse.EventSources
import java.util.concurrent.TimeUnit

class SseManager {

//    private var logging = HttpLoggingInterceptor().apply {
//        level = HttpLoggingInterceptor.Level.BODY
//    }

     constructor() {
        var sslData = NetworkModule.getSSlSocketFactory()

        okHttpClient = OkHttpClient.Builder()
//            .addInterceptor(logging)
            .connectTimeout(30, TimeUnit.SECONDS)
            .writeTimeout(30, TimeUnit.SECONDS)
            .readTimeout(0, TimeUnit.SECONDS)
            .connectionPool(ConnectionPool(5, 30, TimeUnit.SECONDS)) // 连接池优化（可选）
            .pingInterval(20, TimeUnit.SECONDS) // TCP心跳间隔
            .retryOnConnectionFailure(true)
  /*          .connectionSpecs(
                listOf(
                    ConnectionSpec.CLEARTEXT,
                    ConnectionSpec.MODERN_TLS
                )
            ) // 支持 HTTP/HTTPS*/
            .sslSocketFactory(sslData.socketFactory, sslData.trustAllCert)
            .hostnameVerifier { hostname, session -> true }

            .build()
    }

    private var okHttpClient: OkHttpClient

    // SSE 连接实例（ nullable，避免内存泄漏）
    private var eventSource: EventSource? = null

    //    private var lastEventId: String? = null // 记录最后一个事件 ID
    private val listeners = mutableListOf<SseCallback2?>() // 客户端数据监听器

    // 重连延迟（指数退避：1s → 2s → 4s → ... → 30s 上限）
    private var retryDelayMillis = 1000L
    private val maxRetryDelay = 30 * 1000L // 最大重连延迟

    // 连接状态回调（给外部使用）
   private var callback: SseCallback2? = null

    fun addListener(callback: SseCallback2) {
        listeners.add(callback)
    }

    // 初始化 SSE 请求
    fun connect(sseUrl: String, body: RequestBody?, headers: Map<String, String> = emptyMap()) {
        // 1. 构建 SSE 请求（必须是 GET 方法，且支持 SSE 协议）
        val requestBuilder = Request.Builder()
            .url(sseUrl)
            .header("Accept", "text/event-stream") // 关键：告知服务器接收 SSE 格式
            .header("Cache-Control", "no-cache")   // 禁用缓存，避免重复数据
            .header("Connection", "keep-alive")    // 保持长连接

        if (body != null) {
            requestBuilder.post(body)
        }

        // 添加自定义请求头（如 Token、User-Agent 等）
        headers.forEach { (key, value) ->
            requestBuilder.header(key, value)
        }

        // 断线重连时携带上次最后一个事件 ID（避免漏数据）
//        lastEventId?.let {
//            requestBuilder.header("Last-Event-ID", it)
//        }

        val request = requestBuilder.build()

        // 2. 构建 EventSource（OkHttp SSE 核心）
        val eventSourceListener = object : EventSourceListener() {
            // 连接成功回调
            override fun onOpen(eventSource: EventSource, response: Response) {
                super.onOpen(eventSource, response)
                listeners.forEach {
                    it?.onConnected()
                }
                retryDelayMillis = 1000L // 重置重连延迟（连接成功后恢复初始值）
            }

            // 接收服务器消息（核心回调）
            override fun onEvent(
                eventSource: EventSource,
                id: String?,
                type: String?,
                data: String
            ) {
                super.onEvent(eventSource, id, type, data)
                listeners.forEach {
                    it?.onMessageReceived(data, type ?: "message")// type 是服务器定义的事件类型
                }
            }

            // 连接断开回调（主动/被动断开都会触发）
            override fun onClosed(eventSource: EventSource) {
                super.onClosed(eventSource)
                listeners.forEach {
                    it?.onDisconnected()
                }
                // 主动断开时不自动重连（通过 flag 控制）
                if (!isManualDisconnect) {
                    scheduleReconnect(sseUrl, body, headers) // 被动断开则重连
                }
            }

            // 连接失败回调（网络异常、服务器错误等）
            override fun onFailure(
                eventSource: EventSource,
                t: Throwable?,
                response: Response?
            ) {
                super.onFailure(eventSource, t, response)
                val errorMsg = t?.message ?: "未知错误"
                listeners.forEach {
                    it?.onError(errorMsg, t)
                }
                scheduleReconnect(sseUrl, body, headers) // 失败后自动重连
            }
        }
        // 创建并启动 SSE 连接
        eventSource =
            EventSources.createFactory(okHttpClient).newEventSource(request, eventSourceListener)

    }

    // 主动断开连接
    fun disconnect() {
        isManualDisconnect = true
        eventSource?.cancel() // 关闭连接
        eventSource = null
        callback?.onDisconnected()
    }

    // 调度重连（指数退避策略）
    private fun scheduleReconnect(
        sseUrl: String,
        body: RequestBody?,
        headers: Map<String, String>
    ) {
        callback?.onReconnecting(retryDelayMillis)
        // 使用 Handler 延迟重连（避免主线程阻塞）
        Handler(Looper.getMainLooper()).postDelayed({
            if (!isManualDisconnect) {
                connect(sseUrl, body, headers) // 重连
                // 指数退避：延迟翻倍，不超过最大值
                retryDelayMillis = minOf(retryDelayMillis * 2, maxRetryDelay)
            }
        }, retryDelayMillis)
    }

    // 防止内存泄漏：释放资源
    fun release() {
        disconnect()
        callback = null
    }

    companion object {
        //        // 单例实例
////        @Volatile
//        private var instance: SseManager? = null
        // 是否主动断开（控制重连逻辑）
        private var isManualDisconnect = false
        val instance: SseManager by lazy { SseManager() }
//        fun getInstance(context: Context, okHttpClient: OkHttpClient): SseManager {
//            return instance ?: synchronized(this) {
//                instance ?: SseManager(context.applicationContext, okHttpClient).also {
//                    instance = it
//                }
//            }
//        }
    }

    // SSE 状态回调接口（外部实现）
    interface SseCallback2 {
        fun onConnected() // 连接成功
        fun onDisconnected() // 连接断开
        fun onMessageReceived(data: String, eventType: String) // 接收消息
        fun onError(errorMsg: String, throwable: Throwable?) // 错误回调
        fun onReconnecting(delayMillis: Long) // 重连中（可选）
    }
}
