package com.sd.cavphmi.net

import okhttp3.HttpUrl
import okhttp3.HttpUrl.Companion.toHttpUrlOrNull
import okhttp3.Interceptor
import okhttp3.Response
import javax.inject.Inject


class BaseUrlInterceptor @Inject constructor() : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        //获取原始request
        var original= chain.request()
        //从request中获取原有的HttpUrl实例oldHttpUrl
        val originalHttpUrl = original.url
//        获取request的创建者builder
        var builder = original.newBuilder()

        //从request中获取headers，通过给定的键url_name
        val headerValue = original.header("urlname")

        if (!headerValue.isNullOrEmpty() && headerValue.count()>0){
            val newHttpUrl = headerValue.toHttpUrlOrNull()

            val url: HttpUrl = originalHttpUrl.newBuilder()
                .host(newHttpUrl!!.host) // 修改Host部分
                .scheme(newHttpUrl.scheme) //
                .port(newHttpUrl.port) //
                .build()

            //如果有这个header，先将配置的header删除，因此header仅用作app和okhttp之间使用
            builder.removeHeader("urlname")
            val newRequest = builder.url(url)
                .build()

            return chain.proceed(newRequest);
        }
        return chain.proceed(builder.build())
    }
}