package com.sd.cavphmi.bindadapters

import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.LinearLayout
import android.widget.TextView
import androidx.core.graphics.toColorInt
import androidx.databinding.BindingAdapter

object ShowOrderObject {

    @JvmStatic
    @BindingAdapter("showOrderLayout")
    fun showOrderLayout(ll: LinearLayout, avpStatus: Int?) {
        when (avpStatus) {
            in 1..6 -> ll.visibility = View.VISIBLE
            else -> {
                ll.visibility = View.GONE
            }
        }
    }

    @JvmStatic
    @BindingAdapter("showOrderCost")
    fun showOrderCost(tv: TextView, actualCost: Float) {
        var color = ForegroundColorSpan("#3C61E2".toColorInt())
        var sb = SpannableStringBuilder()
        sb.append("${actualCost}元")
        sb.setSpan(color, 0, actualCost.toString().count(), Spannable.SPAN_INCLUSIVE_EXCLUSIVE)
        tv.setText(sb)
    }
}