package com.sd.cavphmi.bean

/**
 *
 * 联网车辆状态数据 (只有发生变化的数据才推送)
 * {"vehicleStatistics":{"total":0,"minibus":0,"bus":0,"sweeper":0,"selling":3,"taxi":0,"brt":0,"patrol":0},"vehicleStatusList":[{"id":"263","type":"selling","status":0,"driveMode":1},{"id":"265","type":"selling","status":0,"driveMode":1},{"id":"267","type":"selling","status":0,"driveMode":1}]}
 * **/
data class VehicleStats(
    val vehicleStatistics: VehicleStatistics,
    val vehicleStatusList: List<VehicleStatus>
)

data class VehicleStatistics(
    val brt: Int,
    val bus: Int,
    val minibus: Int, //小巴车在线数量
    val patrol: Int,
    val selling: Int,
    val sweeper: Int,
    val taxi: Int,
    val total: Int//总的在线数量
)

// 状态变化的车辆，对象型数组
data class VehicleStatus(
    val driveMode: Int,
    val id: String,
    val status: Int, // 必填，int 类型，车辆状态编码：0-离线、1-在线
    val type: String  // 选填，字符串类型，车辆类型
)