package com.sd.cavphmi.base

import android.app.ProgressDialog
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.OptIn
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.media3.common.util.UnstableApi
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory
import androidx.media3.exoplayer.source.MediaSource

import com.sd.cavphmi.net.NetLoadStatus
import com.sd.cavphmi.utils.ToastHelper

//import com.gyf.immersionbar.ImmersionBar
//import com.gyf.immersionbar.components.ImmersionFragment


open abstract class BaseFragment<Bind : ViewDataBinding, VM : MyBaseViewModel> :
    Fragment(),
    IBinding<VM> {

    protected lateinit var viewModel: VM

    protected lateinit var binding: Bind

//    private var loadDialogFragment: LoadDialogFragment? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        initDataBinding(container)
        return binding.root
    }

//    override fun initImmersionBar() {
//        initStatuBar()
//    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        setListener()
        initView()
        initListener()
        getToData()
    }

    private fun initDataBinding(viewGroup: ViewGroup?) {
        binding = DataBindingUtil.inflate(layoutInflater, initContentView(), viewGroup, false)

        viewModel = initViewModel()
        binding.setVariable(initVariableId(), viewModel)
    }

//    private lateinit var bar: ImmersionBar

    /**
     * 初始化状态栏
     */
//    private fun initStatuBar() {
//        var color = getStatuBarColor()
//        if (color == -1) {
//
//        } else {
//            bar = ImmersionBar.with(this)
//                .fitsSystemWindows(true)
//                .statusBarColor(color)
//                .autoStatusBarDarkModeEnable(isAutoStatusBarDarkModeEnable())
//            bar.init()
//        }
//
//    }

    abstract fun getStatuBarColor(): Int

    open fun isAutoStatusBarDarkModeEnable(): Boolean {
        return true
    }

    abstract fun initView()

    private fun setListener() {
        viewModel.loadStatu.observe(viewLifecycleOwner, Observer { t: NetLoadStatus ->
            netLoad(t)
        })
    }

    private fun netLoad(t: NetLoadStatus) {
        when (t) {
            NetLoadStatus.LOADING -> loading()
            NetLoadStatus.SUCCESS -> success()
            NetLoadStatus.ERROR -> onerror(t.getErrorMsg())
            NetLoadStatus.TOAST -> onToast(t.getToastMsg())
            NetLoadStatus.COMPLETE -> complete()
            NetLoadStatus.EMPTY -> empty()
            NetLoadStatus.LOGINTIMEOUT -> loginOutTime()
            NetLoadStatus.NOMOREDATA -> TODO()
        }
    }

    open fun initListener() {

    }

    open fun getToData() {

    }

    open fun loading() {
//        loadDialogFragment?.dismiss()
//        loadDialogFragment = LoadDialogFragment.newInstance("")
//        loadDialogFragment?.show(childFragmentManager, "")
    }

    open fun success() {
//        loadDialogFragment?.dismiss()
    }

    open fun onerror(msg: String) {
//        loadDialogFragment?.dismiss()
        if (!msg.isNullOrEmpty()) {
//            ToastHelper.showShort(requireContext(), msg)
        }
    }

    open fun onToast(msg: String) {
//        ToastHelper.showShort(requireContext(), msg)
    }


    open fun complete() {
//        loadDialogFragment?.dismiss()
    }

    open fun empty() {
    }

    open fun loginOutTime() {
//        LogUtil.e("----------------登录超时")
        ToastHelper.showShort(requireContext(), "登录超时")
//        startActivity(Intent(context, LoginActivity::class.java).apply {
//            putExtra(MyContants.IS_LOGIN_TIMEOUT, true)
//        })
    }

    fun setOtherViewModel(viewModel: OtherBaseViewModel) {
        viewModel.loadStatu.observe(viewLifecycleOwner, {
            netLoad(it)
        })
    }
//    fun setThridViewModel(viewModel: MyBaseViewModel) {
//        viewModel.loadStatu.observe(this, {
//            netLoad(it)
//        })
//    }

    private var myDialog: ProgressDialog? = null

    /**
     * 加载等待
     */
     fun showProgressDialog(tip:String="正在加载") {
        myDialog = ProgressDialog(requireContext())
        myDialog!!.setProgressStyle(ProgressDialog.STYLE_SPINNER)
        myDialog!!.setMessage(tip)
        myDialog!!.setIndeterminate(false)
        myDialog!!.setCancelable(true)
        myDialog!!.show()
    }

     fun disDiaLog() {
        myDialog?.dismiss()
    }

    @OptIn(UnstableApi::class)
    fun createMediaSourceFactory(): MediaSource.Factory{
        return DefaultMediaSourceFactory(requireContext()).setLiveTargetOffsetMs(5000L)
     }

}