package cn.spatiotemporal.web.core.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.spatiotemporal.web.core.domain.Treeable;

/**
 * 树形数据结构通用工具类
 * @author marquis
 *
 */
public class TreeUtils {
	
	/**
	 * 从列表转换成树
	 * @param list
	 * @return
	 */
	public static <T extends Treeable> List<T> list2Tree(List<T> list) {
		Map<Serializable, Treeable> map = new HashMap<Serializable, Treeable>();
		List<T> tree = new ArrayList<T>();
		list.forEach(node -> {
			map.put(node.getId(), node);
			Treeable parent = map.get(node.getParentId());
			if (parent == null) {
				tree.add(node);
			} else {
				parent.addChild(node);
			}
		});
		
		return tree;
	}
	
	/**
	 * 从树转换成列表
	 * @param tree
	 * @return
	 */
	public static <T extends Treeable> List<T> tree2List(List<T> tree) {
		List<T> list = new ArrayList<T>();
		tree.forEach(node -> {
			list.add(node);
			if (node.hasChildren()) {
				list.addAll(tree2List(node.getChildren()));
			}
		});
		return list;
	}

}
