package cn.spatiotemporal.web.core.utils;

import java.util.Random;
import java.util.function.Function;

/**
 * 服务端工具类
 * @author marquis
 *
 */
public class BackEndUtils {

	private static Function<Character, Byte> char2Byte = (c) -> {
		return (byte) (c > 96 ? c - 87 : c > 64 ? c - 55 : c - 48);
	};
	
	private static Function<Long, byte[]> long2Array = (l) -> {
		byte[] a = new byte[8];
		for (int i = 0; i < 8; i++) {
			a[i] = (byte) ((l >> (i * 8)) & 0xff);
		}
		return a;
	};
	
	private static Function<String, byte[]> string2Array = (s) -> {
		int len = s.length() / 2;
		byte[] a = new byte[len];
		for (int i = 0; i < len; i++) {
			a[i] = (byte) (char2Byte.apply(s.charAt(i)) | (char2Byte.apply(s.charAt(i + len)) << 4));
		}
		return a;
	};
	
	private static Key key = (uuid, value) -> {
		try {
			byte[] code = string2Array.apply(uuid.replaceAll("-", ""));
			long next = (new Random(value)).nextLong();
			for (int i = 0; i < code.length; i+=8) {
				for (int j = 0; j < 8; j++) {
					next ^= (code[i + j] & 0xff) << (j * 8);
				}
			}
			return next;
		} catch (Exception e) {
			return (new Random(value)).nextLong();
		}
	};
	
	/**
	 * 解析Hex字符串
	 * @param request
	 * @param code
	 * @return
	 */
	public static String parseHex(String hex, String code) {

		byte[] pis = long2Array.apply(Double.doubleToRawLongBits(Math.PI) ^ Long.parseLong(code));
		
		return BackEndStream.hex(hex).convert((a, b, i) -> (byte)((byte)a ^ (byte)b ^ (byte)pis[i % 8])).output(false);
	}
	
	/**
	 * 生成Hex字符串
	 * @param request
	 * @param code
	 * @return
	 */
	public static String toHex(String src, String code) {
		byte[] pis = long2Array.apply(Double.doubleToRawLongBits(Math.PI) ^ Long.parseLong(code));
		
		return BackEndStream.of(src).convert((a, b, i) -> (byte)((byte)a ^ (byte)b ^ (byte)pis[i % 8])).output(true);
	}
	
	public static String nextCode(String device, String current) {
		return String.valueOf(key.next(device, Long.parseLong(current)));
	}
	
	public static boolean valiadCode(String device, String prev, String current) {
		try {
			return (Long.parseLong(current) ^ Double.doubleToRawLongBits(Math.PI) ^ key.next(device, Long.parseLong(prev))) == 0;
		} catch (Exception e) {
			return false;
		}
	}
	
	@FunctionalInterface
	interface Key {
		long next(String s, long l);
	}
}
