package cn.spatiotemporal.web.core.utils;

import java.util.function.Function;

/**
 * 服务端通讯安全算法
 * @author marquis
 *
 */
public class BackEndStream {
	
	private byte[] stream;
	
	private static Function<Byte, Character> byte2Char = (b) -> {
		return (char) (b > 9 ? b + 55 : b + 48);
	};
	
	private static Function<Character, Byte> char2Byte = (c) -> {
		return (byte) (c > 96 ? c - 87 : c > 64 ? c - 55 : c - 48);
	};
	
	private static Function<byte[], String> array2String = (a) -> {
		StringBuffer sa = new StringBuffer();
		StringBuffer sb = new StringBuffer();
		for (byte b : a) {
			sa.append(byte2Char.apply((byte) (b & 0x0f)));
			sb.append(byte2Char.apply((byte) ((b >> 4) & 0x0f)));
		}
		return sa.append(sb).toString();
	};
	
	private static Function<String, byte[]> string2Array = (s) -> {
		int len = s.length() / 2;
		byte[] a = new byte[len];
		for (int i = 0; i < len; i++) {
			a[i] = (byte) (char2Byte.apply(s.charAt(i)) | (char2Byte.apply(s.charAt(i + len)) << 4));
		}
		return a;
	};
	
	BackEndStream(byte[] a) {
		stream = a;
	}
	
	static BackEndStream of(String src) {
		return new BackEndStream(src.getBytes());
	}
	
	static BackEndStream hex(String hex) {
		return new BackEndStream(string2Array.apply(hex));
	}
	
	BackEndStream convert(Converter conveter) {
		for (int i = stream.length -1; i >= 0; i--) {
			stream[i] = conveter.convert((i > 0 ? stream[i - 1] : 0x00), stream[i], i);
		}
		return this;
	}
	
	/**
	 * 是否输出为hex字符串
	 * @param flag
	 * @return
	 */
	String output(boolean flag) {
		return flag ? array2String.apply(stream) : new String(stream);
	}
	
	@FunctionalInterface
	interface Converter {
		byte convert(byte a, byte b, int i);
	}
}
