package cn.spatiotemporal.web.core.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import cn.spatiotemporal.web.core.annotation.DisableSysLog;
import cn.spatiotemporal.web.core.dao.ServiceLogDao;
import cn.spatiotemporal.web.core.domain.entity.admin.ServiceLog;
import cn.spatiotemporal.web.core.service.IServiceLogService;

@Service
@ConditionalOnMissingBean(annotation = DisableSysLog.class)
public class ServiceLogServiceImpl implements IServiceLogService {
	
	@Autowired
	private ServiceLogDao dao;

	@Override
	public void save(ServiceLog sysLog) {
		dao.insert(sysLog);
	}

}
