package cn.spatiotemporal.web.core.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import cn.spatiotemporal.web.core.annotation.DisableSysLog;
import cn.spatiotemporal.web.core.dao.OperationLogDao;
import cn.spatiotemporal.web.core.domain.entity.admin.OperationLog;
import cn.spatiotemporal.web.core.service.IOperationLogService;

@Service
@ConditionalOnMissingBean(annotation = DisableSysLog.class)
public class OperationLogServiceImpl implements IOperationLogService {
	
	@Autowired
	private OperationLogDao dao;

	@Override
	public void save(OperationLog userLog) {
		dao.insert(userLog);
	}

}
