package cn.spatiotemporal.web.core.security;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;

/**
 * 实现LogoutSuccessHandler接口，处理退出成功
 * @author marquis
 *
 */
@Component
public class RestLogoutSuccessHandler implements LogoutSuccessHandler {

	@Override
	public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication)
			throws IOException, ServletException {
		//清除token
		
		//返回客户端结果信息
		response.getWriter().write(JSON.toJSONString(new ReturnVO<Void>(ReturnEnum.SUCCESS)));
	}

}
