package cn.spatiotemporal.web.core.security;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;

/**
 * 实现AuthenticationFailureHandler接口，处理用户登录失败
 * @author marquis
 *
 */
@Component
public class RestAuthenticationFailureHandler implements AuthenticationFailureHandler {

	@Override
	public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
		response.setCharacterEncoding("utf-8");
        response.setContentType("text/javascript;charset=utf-8");
		String failed= new String(JSON.toJSONString(new ReturnVO<Void>(ReturnEnum.ERROR_ACCOUNT_OR_PASSWORD)).getBytes(),"UTF-8");
		response.getWriter().write(failed);
	}
}
