package cn.spatiotemporal.web.core.security;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;

/**
 * 实现AuthenticationEntryPoint接口，处理用户未登录
 * 
 * @author marquis
 *
 */
@Component
public class RestAuthenticationEntryPoint implements AuthenticationEntryPoint {

	@Override
	public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e)
			throws IOException, ServletException {
		response.setCharacterEncoding("utf-8");
        response.setContentType("text/javascript;charset=utf-8");
		response.getWriter().write(JSON.toJSONString(new ReturnVO<Void>(ReturnEnum.ERROR_NO_AUTHORITY)));
	}
}
