package cn.spatiotemporal.web.core.permission;


import java.lang.reflect.Method;
import java.util.List;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.Authority;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;

import lombok.extern.slf4j.Slf4j;

@Aspect
@Component
@Slf4j
public class PermissionAspect {
	@Pointcut("execution( * cn.spatiotemporal.web..*controller..*Controller*.*(..))")
	 public void pointCut() {
		
    }
	@Around("pointCut()")
	public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable{
		MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        PermissionSource ps = method.getAnnotation(PermissionSource.class);
        if(ps!=null) {
	        log.info(ps.code());
	        String psCode = ps.code();
	        if (psCode.contains(".")) {
	        	psCode = psCode.substring(0, psCode.indexOf("."));
	        }
	      //如果方法上Log注解不为空，则执行proceed()
	        Authentication auth =  SecurityContextHolder.getContext().getAuthentication();
	        if(auth==null || auth.getPrincipal() instanceof String) {
	        	throw new BaseBusinessException(ReturnEnum.ERROR_NO_AUTHORITY);
	        }
	        User userDetails =(User) auth.getPrincipal();
	        List <String> authList =  userDetails.getPermissions();
	        if(!authList.contains(psCode) && !authList.contains(ps.code())) {
	        	throw new BaseBusinessException(ReturnEnum.ERROR_PERMISSION_DENIED);	
	        }
        }
        return joinPoint.proceed();
	}

}
