package cn.spatiotemporal.web.core.exception.handler;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@RestControllerAdvice
public class GlobalExceptionHandler {

	/**
	 * 未知异常处理
	 * @param e
	 * @return
	 */
	@ExceptionHandler(value = Exception.class)
	@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
	public ReturnVO<Void> exceptionHandler(Exception e) {
		log.error(ReturnEnum.FAILED.getMessage(), e);
		return new ReturnVO<Void>(ReturnEnum.FAILED.getCode(), e.getMessage());
	}
	
	@ExceptionHandler(value = BaseBusinessException.class)
	@ResponseBody
	public ReturnVO<Void> businessExceptionHandler(BaseBusinessException e) {
		log.error(e.getMessage(), e);
		return new ReturnVO<Void>(e.getCode(), e.getMessage());
	}
	
	/**
	 * 
	 * @Title: handlerMaxUploadFile    
	 * @Description: 捕获异常：MaxUploadSizeExceededException
	 * @param ex
	 * @return  
	 * ReturnVO<Void>
	 */
    @ExceptionHandler(MaxUploadSizeExceededException.class)
    public ReturnVO<Void> handlerMaxUploadFile(MaxUploadSizeExceededException ex) {
    	String msg = "文件上传大小不能超过4MB！";
    	log.warn(msg);
		return new ReturnVO<Void>("400", msg);       
    }
}
