package cn.spatiotemporal.web.core.exception;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;

/**
 * 业务异常类的公共基类
 * @author marquis
 *
 */
public class BaseBusinessException extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4534112171112827815L;
	
	private String code;
	
	public BaseBusinessException(ReturnEnum returnEnum) {
		super(returnEnum.getMessage());
		this.code = returnEnum.getCode();
	}

	public BaseBusinessException(String code, String message) {
		super(message);
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
}
