package cn.spatiotemporal.web.core.domain.entity.admin;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.userdetails.UserDetails;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import cn.spatiotemporal.web.core.domain.entity.CommonEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@TableName("admin_user")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class User extends CommonEntity implements Serializable, UserDetails, CredentialsContainer  {
	private static final long serialVersionUID = 2114355975229097429L;
	
	/**
	 * 请求url的资源地址
	 */
	@TableField(exist = false)
	private String uri;
	
	/**
	 * 扩展条件
	 */
	@TableField(exist = false)
	private Map<String, Object> extraContext;
	
	/**
	 * 成员
	 */
	private Long memberId;

	private String username;
	
	private String password;
	
	private String salt;
	
	@TableField(exist = false)
	private String accessToken;
	
	@JsonSerialize(using = ToStringSerializer.class)
	private Long orgId;
	
	@TableField("is_enabled")
	private boolean enabled;
	
	private List<String> roles;
	
	private List<Authority> authorities;
	
	private List<String> permissions;
	
	private String realName;	

	@Override
	public boolean isAccountNonExpired() {
		// 账号永不过期
		return true;
	}

	@Override
	public boolean isAccountNonLocked() {
		// 与账号可用状态相同
		return isEnabled();
	}

	@Override
	public boolean isCredentialsNonExpired() {
		// 密码永不过期
		return true;
	}

	@Override
	public void eraseCredentials() {
		// TODO 未完成
	};
}
