package cn.spatiotemporal.web.core.domain.entity.admin;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import cn.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 系统服务日志表
 *
 * @author wenxuan.hu
 * @since 2021-01-20
 */
@TableName("admin_service_log")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class ServiceLog extends CommonEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * 模块ID
	 */
	@TableField("module_id")
	private String moduleId;

	/**
	 * 类名称
	 */
	@TableField("class_name")
	private String className;

	/**
	 * 用户操作
	 */
	@TableField("service")
	private String service;

	/**
	 * 响应时间
	 */
	@TableField("response_time")
	private Integer responseTime;

	/**
	 * 请求方法
	 */
	@TableField("method")
	private String method;

	/**
	 * 请求参数
	 */
	@TableField("params")
	private String params;

	/**
	 * 状态：Success成功 Fail失败
	 */
	@TableField("status")
	private String status;

	/**
	 * 错误信息
	 */
	@TableField("error_msg")
	private String errorMsg;

	/**
	 * IP地址
	 */
	@TableField("log_ip")
	private String logIp;
}
