package cn.spatiotemporal.web.core.domain.entity.admin;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import cn.spatiotemporal.web.core.domain.entity.CommonEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 操作日志表
 *
 * @author wenxuan.hu
 * @since 2021-01-20
 */
@TableName("admin_operation_log")
@Data
@EqualsAndHashCode(callSuper=false)
@ToString(callSuper=true)
public class OperationLog extends CommonEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	@TableField("operator_id")
	private String operatorId;

	@TableField("operator_name")
	private String operatorName;

	/**
	 * 用户操作
	 */
	@TableField("operation")
	private String operation;

	/**
	 * 响应时间
	 */
	@TableField("response_time")
	private Integer responseTime;

	/**
	 * 请求方法
	 */
	@TableField("method")
	private String method;

	/**
	 * 请求参数
	 */
	@TableField("params")
	private String params;

	/**
	 * 状态：Success成功 Fail失败
	 */
	@TableField("status")
	private String status;

	/**
	 * 错误信息
	 */
	@TableField("error_msg")
	private String errorMsg;

	/**
	 * IP地址
	 */
	@TableField("log_ip")
	private String logIp;
}
