package cn.spatiotemporal.web.core.domain.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.Version;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 完整的实体类基类（采用标记删除、乐观锁控制和多租户隔离等）
 * @author marquis
 *
 */
@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class CommonEntity extends BaseEntity {
	/**
	 * 
	 */
	private static final long serialVersionUID = -1844922701089800582L;

	/**
	 * 逻辑删除标记
	 */
	@TableField("is_deleted")
	@TableLogic
	private Integer deleted;

	/**
	 * 版本（用于乐观锁并发控制策略）
	 */
	@TableField("version")
	@Version
    private Long version;

	/**
	 * 租户ID（用于多租户数据隔离）
	 */
	@TableField("tenant_id")
	@JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
}
