package cn.spatiotemporal.web.core.domain.entity;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;

import lombok.Data;

/**
 * 一般持久化实体类的基类
 * @author marquis
 *
 * @param <ID>
 */
@Data
public class BaseEntity implements Serializable {
	

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 物理主键，采用mybatis-plus默认主键策略(生成全局唯一主键)
	 */
	@TableId(value = "id")
	@JsonSerialize(using = ToStringSerializer.class)
	private Long id;
	
	/**
	 * 创建者
	 */
	@TableField(value="create_user", fill=FieldFill.INSERT)
    private String createUser;

	/**
	 * 创建时间
	 */
	@TableField(value="create_time", fill=FieldFill.INSERT)
	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

	/**
	 * 更新者
	 */
	@TableField(value="update_user", fill=FieldFill.INSERT_UPDATE)
    private String updateUser;

	/**
	 * 更新时间
	 */
	@TableField(value="update_time", fill=FieldFill.INSERT_UPDATE)
	@JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
