package cn.spatiotemporal.web.core.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 通用树形数据结构
 * @author marquis
 *
 */
public interface Treeable<T> {
	
	/**
	 * 获取当前节点ID
	 * @return
	 */
	public Serializable getId();

	/**
	 * 获取父节点ID
	 * @return
	 */
	public Serializable getParentId();
	
	/**
	 * 获取子节点列表
	 * @return
	 */
	public List<T> getChildren();
	
	/**
	 * 设置子节点列表
	 * @param list
	 */
	public void setChildren(List<T> list);
	
	/**
	 * 是否存在子节点
	 * @return
	 */
	default boolean hasChildren() {
		return getChildren() != null && !getChildren().isEmpty(); 
	}
	
	default void addChild(T child) {
		if (!hasChildren()) {
			setChildren(new ArrayList<T>());
		}
		getChildren().add(child);
	}
}
