package cn.spatiotemporal.web.core.config.security;

import org.springframework.boot.context.properties.ConfigurationProperties;

import lombok.Data;

@ConfigurationProperties(prefix = "security")
@Data
public class SecurityProperties {
	
	/**
	 * 安全模式：
	 *   simple   简答模式，采用内部集成的rbac管理模块
	 *   jwt-redis    采用jwt来验证，获取储存在redis里的用户/权限信息
	 *   disable      关闭安全服务
	 */
	private String mode = "jwt-redis";
	
	/**
	 * 允许无需验证即可访问的路径（含通配符）
	 */
	private String[] permitAccess= {"/admin/sso/**"};
	
	private String[] authAccess= {"/admin/user/**","/admin/role/**","/admin/role/**","/admin/org/**","/admin/menu/**"};
}
