package cn.spatiotemporal.web.core.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;

/**
 * 关闭系统自动日志组件
 * @author marquis
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
@Documented
public @interface DisableSysLog {

	/**
	 * 默认属性，与{@link #basePackages()}是同一个属性，简写的时候等同于指定了 {@link #basePackages()}。
	 * 例如: 可以用{@code @EnableAsyncClients("org.my.pkg")}来替代
	 * {@code @EnableAsyncClients(basePackages="org.my.pkg")}.
	 * @return the array of 'basePackages'.
	 */
	String[] value() default {};
}
