# spatiotemporal-web-core

时空开放平台Web端 核心模块。以下简称Web端核心模块(web-core)，提供Web端工程的公共功能。

## 引用方式

Web端应用工程一般需要引用Web端核心模块(web-core)。可以在POM.xml文件的dependencies中加入以下依赖。  

```xml
    <dependency>
      <groupId>cn.spatiotemporal</groupId>
      <artifactId>spatiotemporal-web-core</artifactId>
      <version>1.0.0-RELEASE</version>
    </dependency>
```

注意选择合适的版本。

## Web端公共功能

### SpringMVC支持
集成SpringMVC，对页面访问参数和返回值自动进行json序列化、反序列化处理等。

### Spring访问安全
基于SpringSecurity，对客户端进行jwt认证拦截，检核jwt的存在性和有效性。

### 权限控制
基于RBCA模型的权限控制。提供注解方式的方法级权限控制，自动匹配用户-角色与所访问的方法的权限是否相符。

### 统一数据访问层
基于MyBatis-Plus，提供统一的数据访问层支持。包括Entity基类、Dao基类等。  
支持分布式自动生成主键、逻辑删除、创建/更新信息自动注入、事务管理、乐观锁、基于租户的数据隔离等。  
支持多种RDBMS数据库（默认为mysql），支持连接池管理（基于HikariCP连接池）。

### 统一认证支持
支持两种模式的单点登录SSO和统一认证：基于jwt的认证模式和基于CAS的认证模式。

### 前后端通信加密
基于非公开加密算法和密钥管理，增强前后端通信时安全性。   
**注：需要客户端与服务端成对使用。**

### 自动化日志
基于AOP模式，提供注解方式的用户操作、系统日志日志自动写入。

### 数据字典支持
通过redis提供数据字典的访问与转换功能。

## 公共工具类

### 用户权限工具类AuthorityUtils
提供与用户、权限相关的公共功能，包括获取当前用户信息等。

### JWT工具类JwtTokenUtils
提供jwt生成、jwt解码等相关的工具类。

### 数据字典工具类DictUtils
提供数据字典的获取、自动翻译等功能。

### IP地址工具类
提供获取客户端IP、服务端IP等功能。

## License
时空开放平台是一个基于[Apache 2.0 license](https://www.apache.org/licenses/LICENSE-2.0.html)发布的开源软件。
