package cn.spatiotemporal.commons.util;

import java.net.InetAddress;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import cn.hutool.core.net.NetUtil;
import cn.hutool.system.HostInfo;
import cn.hutool.system.SystemUtil;
import cn.hutool.system.oshi.OshiUtil;
import oshi.hardware.NetworkIF;

/**
 *
 * @ClassName:IpUtil
 * @Description: IpUtil
 * @date 2022年12月14日 下午午6:10:00
 *
 * @author  yifan.wang
 * @version
 * @since   JDK 1.8
 */
public class IpUtil {
    /**
     * 获取用户真实IP地址，不使用request.getRemoteAddr();的原因是有可能用户使用了代理软件方式避免真实IP地址,
     *
     * 可是，如果通过了多级反向代理的话，X-Forwarded-For的值并不止一个，而是一串IP值，究竟哪个才是真正的用户端的真实IP呢？
     * 答案是取X-Forwarded-For中第一个非unknown的有效IP字符串。
     *
     * 如：X-Forwarded-For：192.168.1.110, 192.168.1.120, 192.168.1.130,
     * 192.168.1.100
     *
     * 用户真实IP为： 192.168.1.110
     *
     * @param request
     * @return
     */
    public static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    
    /**
     * 
     * @Title: getEthIp4    
     * @Description: 
     * 网卡名称为eth
     * en标识ethernet
		 o：主板板载网卡，集成是的设备索引号
		 p：独立网卡，PCI网卡
		 s：热插拔网卡，USB之类的扩展槽索引号
		 nnn（数字）：MAC地址+主板信息计算得出唯一序列
     * @param ip
     * @return  
     * String
     */
    public static String getEthIp4(String ip) {
        String ethip = ip;
        List<NetworkIF> networkIFs = OshiUtil.getNetworkIFs();
        for (NetworkIF networkIF : networkIFs) {
//        	System.out.println("networkIF.getName():" + networkIF.getName() + "|" + String.join(",", networkIF.getIPv4addr())   );
            if(networkIF.getName().startsWith("eth") || networkIF.getName().startsWith("en")) {
                String[] iPv4addr = networkIF.getIPv4addr();
                if(null != iPv4addr && iPv4addr.length > 0) {
                    ethip = iPv4addr[0];
                    return ethip;
                }
            }
        }
        return ethip;
    }
    

    
//    public static void main(String[] args) {
//    	HostInfo hostInfo = SystemUtil.getHostInfo();
//    	System.out.println(hostInfo.getAddress());
//    	System.out.println("=====================");
//    	InetAddress inetAddress = NetUtil.getLocalhost();
//    	System.out.println(inetAddress.getHostAddress());    	
//    	System.out.println("=====================");
//    	System.out.println(IpUtil.getEthIp4("127.0.0.1"));
//	}
}
