package cn.spatiotemporal.commons.config;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;

import lombok.extern.slf4j.Slf4j;

/**
 * 
 * @ClassName: ServerRegisterAutoConfig2
 * @Description: 服务器注册自动配置类 可以加入间隔时间参数
 * @date 2023年8月29日 下午5:08:29
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
@Slf4j
@Order(Ordered.LOWEST_PRECEDENCE)
public class ServerRegisterAutoConfig implements ImportBeanDefinitionRegistrar {

	Logger logger = LoggerFactory.getLogger(ServerRegisterAutoConfig.class);

	@Override
	public void registerBeanDefinitions(AnnotationMetadata annotationMetadata,
			BeanDefinitionRegistry beanDefinitionRegistry) {
		// 获取EnableServerRegister注解的所有属性的value
		Map<String, Object> attributes = annotationMetadata.getAnnotationAttributes(EnableServerRegister.class.getName());
		if (attributes == null) {
			return;
		}
		// 获取autoRegister属性的value
		Boolean autoRegister = (Boolean) attributes.get("autoRegister");
		if (autoRegister == null || autoRegister == false) {
			return;
		}
		Integer period = (Integer) attributes.get("period");
		BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(EnableServerCorn.class);

		AbstractBeanDefinition definition = beanDefinitionBuilder.getBeanDefinition();

		MutablePropertyValues values = definition.getPropertyValues();
		values.addPropertyValue("period", period);
		beanDefinitionRegistry.registerBeanDefinition("enableServerCorn", definition);
		logger.info("enableServerRegister服务注册成功!");
	}
}