package cn.spatiotemporal.commons.config;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.context.annotation.Import;


/**
 * 
 * @ClassName: EnableServerRegister2    
 * @Description: 服务器注册开启注解
 * @date 2023年8月29日 下午5:08:01    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Import(ServerRegisterAutoConfig.class)
@Documented
@Inherited
public @interface EnableServerRegister {
    //是否启用 默认启用
    boolean autoRegister() default true;

    //间隔时间 时间单位(second) 默认30second
    int period() default 30;

}