package cn.spatiotemporal.commons.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import cn.spatiotemporal.commons.exception.BaseBusinessException;

import lombok.extern.slf4j.Slf4j;



/**
 * @ClassName: StrUtil
 * @Description: 字符工具类
 * @date 2023年9月7日 上午9:35:45
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
@Slf4j
public class StrUtil {
	/**
	 * 转字符串
	 *
	 * @param obj
	 * @return
	 */
	public static String nvl(Object obj) {
		return (obj == null) ? "" : obj.toString();
	}

	/**
	 * 为object中的所有String属性去除空格字符
	 *
	 * @param object 待处理的实体对象
	 * @return : java.lang.Object
	 */
	public static Object replaceBlankSpace(Object object) {
		// 获取该类中所有的域(属性)
		Field[] fields = object.getClass().getDeclaredFields();

		for (Field field : fields) {
			// 对所有的属性判断是否为String类型
			if (field.getType().equals(String.class)) {
				// 将私有属性设置为可访问状态
				field.setAccessible(true);
				try {
					String string = (String) field.get(object);
					// 将所有的空格字符用""替换
					if (string != null) {
						string = string.replaceAll(" ", "");
						// 相当于调用了set方法设置属性
						field.set(object, string);
					}
				} catch (IllegalAccessException e) {
					e.printStackTrace();
				}
			}
		}
		return object;
	}

	/**
	 * 为object中的所有String属性去除空格字符，有空格则直接抛出
	 *
	 * @param object 待处理的实体对象
	 * @return : java.lang.Object
	 */
	public static Object replaceBlankOrThrow(Object object) throws BaseBusinessException, IllegalAccessException {
		// 获取该类中所有的域(属性)
		Field[] fields = object.getClass().getFields();

		for (Field field : fields) {
			// 对所有的属性判断是否为String类型
			if (field.getType().equals(String.class)) {
				// 将私有属性设置为可访问状态
				field.setAccessible(true);
				String string = (String) field.get(object);
				// 将所有的空格字符用""替换
				if (string != null) {
					string = string.replaceAll(" ", "");

					/*
					 * if (StringUtils.isEmpty(string)) { throw new BaseBusinessException("999999",
					 * "##### 空字符串，参数异常"); }
					 */

				}
				// 相当于调用了set方法设置属性
				field.set(object, string);
			}
		}
		return object;
	}

	/**
	 * Object是否包含空字符串
	 *
	 * @param object 待处理的实体对象
	 * @return : Boolean false不包含，true包含
	 */
	public static Boolean checkContainsEntity(Object object) {
		// 获取该类中所有的域(属性)
		Class<?> aClass = object.getClass();
		Field[] fields = aClass.getDeclaredFields();
		List<Field> fieldList = new ArrayList<>(Arrays.asList(fields));
		// 获取父类field
		Class<?> superclass = aClass.getSuperclass();
		Field[] supperFields = superclass.getDeclaredFields();
		fieldList.addAll(Arrays.asList(supperFields));

		for (Field field : fieldList) {
			// 对所有的属性判断是否为String类型
			if (field.getType().equals(String.class)) {
				// 将私有属性设置为可访问状态
				field.setAccessible(true);
				String string = null;
				try {
					string = (String) field.get(object);
					// 将所有的空格字符用""替换
					if (string != null && string.contains(" ")) {
						return true;
					}
				} catch (IllegalAccessException e) {
					log.error("##### {} #####", "checkContainsEntity Object是否包含空字符串 发生错误！");
				}
			}
		}
		return false;
	}	

}
