package cn.spatiotemporal.commons.result;

import java.io.Serializable;

import cn.spatiotemporal.commons.enums.ReturnEnum;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description= "REST返回数据")
@Data
public class ReturnVO<T> implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 221173669518504486L;
	
	@ApiModelProperty(value = "执行状态码")
	private String code;

	@ApiModelProperty(value = "返回消息")
	private String msg;

	@ApiModelProperty(value = "返回数据")
	private Object data;
	
	public ReturnVO() {
		this.code = ReturnEnum.SUCCESS.getCode();
		this.msg = ReturnEnum.SUCCESS.getMessage();
	}
	
	public ReturnVO(T obj) {
		this.code = ReturnEnum.SUCCESS.getCode();
		this.msg = ReturnEnum.SUCCESS.getMessage();
		this.data = obj;
	}

	public ReturnVO(ReturnEnum returnEnum) {
		this.code = returnEnum.getCode();
		this.msg = returnEnum.getMessage();
	}

	public ReturnVO(ReturnEnum returnEnum, T obj) {
		this.code = returnEnum.getCode();
		this.msg = returnEnum.getMessage();
		this.data = obj;
	}

	public ReturnVO(String code, String message) {
		this.code = code;
		this.msg = message;
	}

	public ReturnVO(String code, String message, T obj) {
		this.code = code;
		this.msg = message;
		this.data = obj;
	}
}
