package cn.spatiotemporal.commons.result;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description= "REST查询条件")
@Data
public class RequestVO<T> implements Serializable {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -830863935742261168L;

	@ApiModelProperty(value = "每页大小(行数)")
	private Long size;

	@ApiModelProperty(value = "当前页码")
	private Long current;

	@ApiModelProperty(value = "查询条件")
	private T condition;
	
	@ApiModelProperty(value = "排序")
	private String order;
	
	public RequestVO() {
	}
	
	public RequestVO(T obj) {
		this.condition = obj;
	}

	public RequestVO(Long size, Long current, T obj) {
		this.size = size;
		this.current = current;
		this.condition = obj;
	}

	public RequestVO(Long size, Long current, T obj, String order) {
		this.size = size;
		this.current = current;
		this.condition = obj;
		this.order = order;
	}
}
