package cn.spatiotemporal.commons.factory;

import cn.hutool.core.util.StrUtil;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 
 * @ClassName: NamedThreadFactory
 * @Description: 重命名线程池
 * @date 2022年8月11日 下午15:27:23
 * 
 * @author Q.JI
 * @version
 * @since JDK 1.8
 */
public class NamedThreadFactory implements ThreadFactory {

	private final AtomicInteger poolNumber = new AtomicInteger(1);

	private final ThreadGroup threadGroup;

	private final AtomicInteger threadNumber = new AtomicInteger(1);

	public final String namePrefix;

	public NamedThreadFactory(String name) {
		SecurityManager securityManager = System.getSecurityManager();
		if (securityManager != null) {
			this.threadGroup = securityManager.getThreadGroup();
		} else {
			this.threadGroup = Thread.currentThread().getThreadGroup();
		}

		if (StrUtil.isBlank(name)) {
			name = "pool";
		}
		namePrefix = name + "-" + poolNumber.getAndIncrement() + "-thread-";
	}

	@Override
	public Thread newThread(Runnable r) {
		Thread t = new Thread(threadGroup, r, namePrefix + threadNumber.getAndIncrement(), 0);
		if (t.isDaemon()) {
			t.setDaemon(false);
		}

		if (t.getPriority() != Thread.NORM_PRIORITY) {
			t.setPriority(Thread.NORM_PRIORITY);
		}
		return t;
	}
}
