package cn.spatiotemporal.commons.enums;

import cn.spatiotemporal.commons.base.IBaseEnum;

import lombok.Getter;


/**
 * 
 * @ClassName: StatusEnum    
 * @Description: 状态枚举
 * @date 2022年10月11日 上午10:26:14    
 *     
 * @author  Q.JI
 * @version  
 * @since   JDK 1.8
 */
public enum StatusEnum implements IBaseEnum<Integer> {

    ENABLE(1, "启用"),
    DISABLE (0, "禁用");

    @Getter
    private Integer value;

    @Getter
    private String label;

    StatusEnum(Integer value, String label) {
        this.value = value;
        this.label = label;
    }
}
