package cn.spatiotemporal.commons.enums;

import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * REST服务返回状态/消息枚举
 * @author marquis
 *
 */
@Getter
@NoArgsConstructor 
public enum ReturnEnum {

	// 公共返回状态/消息
	// 成功
	SUCCESS("200","访问成功"),
	SUCCESS_CUSTOM("201","调用成功"),//自定义成功状态

	// 一般公共错误信息
	ERROR_POST_PARAM("400", "请求参数异常"),
	ERROR_ACCOUNT_OR_PASSWORD("408","用户名或密码错误"),
	ERROR_EXIST_USERNAME("409","用户名已存在，请直接登录"),
	ERROR_USER_NOT_ENABLED("410","用户已停用，请联系管理员"),
	ERROR_USER_NOT_EXIST("411","用户不存在"),
	ERROR_NO_AUTHORITY("401", "用户未登录，需要登录后才能访问"),
	ERROR_OTHER_DEVICE("401.1", "用户已在其他设备登录，需要重新登录后才能访问"),
	ERROR_TOKEN_EXPIRED("401.2", "用户授权已过期，需要重新登录后才能访问"),	
	
	ERROR_PERMISSION_DENIED("403", "无此访问权限"),
	ERROR_NOT_FOUND("404", "访问对象不存在"),
	ERROR_METHOD_ERROR("405", "访问方式不正确"),
	ERROR_USER_NULL("412","用户名参数为空"),
	
    ERROR_MSG_HAS_CHILD("413","操作失败，当前所选栏目有子栏目信息"),
    ERROR_CRON("414","cron表达式不正确"),
    
	// 一般公共异常信息
	FAILED("500", "服务器内部异常,请稍后重试"), 
	;

	private String code;

	private String message;

	ReturnEnum(String code, String message) {
		this.code = code;
		this.message = message;
	}

	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}
}
